@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property appliedDbfsNumber The number of database file systems set by the automatic snapshot policy.
 * @property createTime The creation time of the resource
 * @property id The ID of the policy.
 * @property lastModified Last modification time of automatic snapshot policy
 * @property policyId Automatic snapshot policy ID
 * @property policyName Automatic snapshot policy name
 * @property repeatWeekdays A collection of automatic snapshots performed on several days of the week.
 * @property retentionDays Automatic snapshot retention days
 * @property status Automatic snapshot policy status
 * @property statusDetail Automatic snapshot policy status details
 * @property timePoints The set of times at which the snapshot is taken on the day the automatic snapshot is executed.
 */
public data class GetAutoSnapShotPoliciesAutoSnapShotPolicy(
    public val appliedDbfsNumber: Int,
    public val createTime: String,
    public val id: String,
    public val lastModified: String,
    public val policyId: String,
    public val policyName: String,
    public val repeatWeekdays: List<String>,
    public val retentionDays: Int,
    public val status: String,
    public val statusDetail: String,
    public val timePoints: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.databasefilesystem.outputs.GetAutoSnapShotPoliciesAutoSnapShotPolicy): GetAutoSnapShotPoliciesAutoSnapShotPolicy = GetAutoSnapShotPoliciesAutoSnapShotPolicy(
            appliedDbfsNumber = javaType.appliedDbfsNumber(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            policyId = javaType.policyId(),
            policyName = javaType.policyName(),
            repeatWeekdays = javaType.repeatWeekdays().map({ args0 -> args0 }),
            retentionDays = javaType.retentionDays(),
            status = javaType.status(),
            statusDetail = javaType.statusDetail(),
            timePoints = javaType.timePoints().map({ args0 -> args0 }),
        )
    }
}
