@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAutoSnapShotPolicies.
 * @property autoSnapShotPolicies A list of Auto Snap Shot Policy Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Auto Snap Shot Policy IDs.
 * @property nameRegex
 * @property names A list of Auto Snap Shot Policy names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetAutoSnapShotPoliciesResult(
    public val autoSnapShotPolicies: List<GetAutoSnapShotPoliciesAutoSnapShotPolicy>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.databasefilesystem.outputs.GetAutoSnapShotPoliciesResult): GetAutoSnapShotPoliciesResult = GetAutoSnapShotPoliciesResult(
            autoSnapShotPolicies = javaType.autoSnapShotPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.databasefilesystem.kotlin.outputs.GetAutoSnapShotPoliciesAutoSnapShotPolicy.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
