@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachNodeNumber the number of nodes of the Database file system.
 * @property category The type of the Database file system. Valid values: `standard`.
 * @property createTime The create time of the Database file system.
 * @property dbfsClusterId The cluster ID of the Database file system.
 * @property ecsLists The collection of ECS instances mounted to the Database file system.
 * @property enableRaid Whether to create the Database file system in RAID way. Valid values : `true` anf `false`.
 * @property encryption Whether to encrypt the Database file system. Valid values: `true` and `false`.
 * @property id The ID of the Instance.
 * @property instanceId The ID of the Database File System
 * @property instanceName The name of the Database file system.
 * @property kmsKeyId The KMS key ID of the Database file system used. This parameter is valid When `encryption` parameter is set to `true`.
 * @property paymentType Thr payment type of the Database file system. Valid value: `PayAsYouGo`.
 * @property performanceLevel The performance level of the Database file system. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
 * @property raidStripeUnitNumber The number of strip . When `enable_raid` parameter is set to `true` will transfer. This parameter is valid When `enable_raid` parameter is set to `true`.
 * @property size The size Of the Database file system. Unit: GiB.
 * @property status The status of the Database file system.
 * @property zoneId The Zone ID of the Database file system.
 */
public data class GetInstancesInstance(
    public val attachNodeNumber: Int,
    public val category: String,
    public val createTime: String,
    public val dbfsClusterId: String,
    public val ecsLists: List<GetInstancesInstanceEcsList>,
    public val enableRaid: Boolean,
    public val encryption: Boolean,
    public val id: String,
    public val instanceId: String,
    public val instanceName: String,
    public val kmsKeyId: String,
    public val paymentType: String,
    public val performanceLevel: String,
    public val raidStripeUnitNumber: String,
    public val size: Int,
    public val status: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.databasefilesystem.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            attachNodeNumber = javaType.attachNodeNumber(),
            category = javaType.category(),
            createTime = javaType.createTime(),
            dbfsClusterId = javaType.dbfsClusterId(),
            ecsLists = javaType.ecsLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.databasefilesystem.kotlin.outputs.GetInstancesInstanceEcsList.Companion.toKotlin(args0)
                })
            }),
            enableRaid = javaType.enableRaid(),
            encryption = javaType.encryption(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            kmsKeyId = javaType.kmsKeyId(),
            paymentType = javaType.paymentType(),
            performanceLevel = javaType.performanceLevel(),
            raidStripeUnitNumber = javaType.raidStripeUnitNumber(),
            size = javaType.size(),
            status = javaType.status(),
            zoneId = javaType.zoneId(),
        )
    }
}
