@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasefilesystem.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The type of the Snapshot.
 * @property createTime The creation time of the snapshot.
 * @property description The description of the snapshot.
 * @property id The ID of the Snapshot.
 * @property instanceId The ID of the database file system.
 * @property lastModifiedTime The last modification time of the snapshot.
 * @property progress The progress of the snapshot.
 * @property remainTime The remaining completion time of the snapshot being created, in seconds.
 * @property retentionDays The retention days of the snapshot.
 * @property snapshotId The ID of the snapshot.
 * @property snapshotName The name of the snapshot.
 * @property snapshotType The creation of the snapshot.
 * @property sourceFsSize Source database file system capacity.
 * @property status The status of the snapshot. Possible values: `progressing`, `accomplished`, `failed`.
 */
public data class GetSnapshotsSnapshot(
    public val category: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val lastModifiedTime: String,
    public val progress: String,
    public val remainTime: Int,
    public val retentionDays: Int,
    public val snapshotId: String,
    public val snapshotName: String,
    public val snapshotType: String,
    public val sourceFsSize: Int,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.databasefilesystem.outputs.GetSnapshotsSnapshot): GetSnapshotsSnapshot = GetSnapshotsSnapshot(
            category = javaType.category(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            lastModifiedTime = javaType.lastModifiedTime(),
            progress = javaType.progress(),
            remainTime = javaType.remainTime(),
            retentionDays = javaType.retentionDays(),
            snapshotId = javaType.snapshotId(),
            snapshotName = javaType.snapshotName(),
            snapshotType = javaType.snapshotType(),
            sourceFsSize = javaType.sourceFsSize(),
            status = javaType.status(),
        )
    }
}
