@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasegateway.kotlin

import com.pulumi.alicloud.databasegateway.DatabasegatewayFunctions.getGatewaysPlain
import com.pulumi.alicloud.databasegateway.kotlin.inputs.GetGatewaysPlainArgs
import com.pulumi.alicloud.databasegateway.kotlin.inputs.GetGatewaysPlainArgsBuilder
import com.pulumi.alicloud.databasegateway.kotlin.outputs.GetGatewaysResult
import com.pulumi.alicloud.databasegateway.kotlin.outputs.GetGatewaysResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object DatabasegatewayFunctions {
    /**
     * This data source provides the Database Gateway Gateways of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.databasegateway.getGateways({
     *     ids: ["example_id"],
     * });
     * export const databaseGatewayGatewayId1 = ids.then(ids => ids.gateways?.[0]?.id);
     * const nameRegex = alicloud.databasegateway.getGateways({
     *     nameRegex: "^my-Gateway",
     * });
     * export const databaseGatewayGatewayId2 = nameRegex.then(nameRegex => nameRegex.gateways?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.databasegateway.get_gateways(ids=["example_id"])
     * pulumi.export("databaseGatewayGatewayId1", ids.gateways[0].id)
     * name_regex = alicloud.databasegateway.get_gateways(name_regex="^my-Gateway")
     * pulumi.export("databaseGatewayGatewayId2", name_regex.gateways[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.DatabaseGateway.GetGateways.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.DatabaseGateway.GetGateways.Invoke(new()
     *     {
     *         NameRegex = "^my-Gateway",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["databaseGatewayGatewayId1"] = ids&#46;Apply(getGatewaysResult => getGatewaysResult&#46;Gateways[0]?.Id),
     *         ["databaseGatewayGatewayId2"] = nameRegex&#46;Apply(getGatewaysResult => getGatewaysResult&#46;Gateways[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasegateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := databasegateway.GetGateways(ctx, &databasegateway.GetGatewaysArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("databaseGatewayGatewayId1", ids.Gateways[0].Id)
     * 		nameRegex, err := databasegateway.GetGateways(ctx, &databasegateway.GetGatewaysArgs{
     * 			NameRegex: pulumi.StringRef("^my-Gateway"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("databaseGatewayGatewayId2", nameRegex.Gateways[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.databasegateway.DatabasegatewayFunctions;
     * import com.pulumi.alicloud.databasegateway.inputs.GetGatewaysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DatabasegatewayFunctions.getGateways(GetGatewaysArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("databaseGatewayGatewayId1", ids.applyValue(getGatewaysResult -> getGatewaysResult.gateways()[0].id()));
     *         final var nameRegex = DatabasegatewayFunctions.getGateways(GetGatewaysArgs.builder()
     *             .nameRegex("^my-Gateway")
     *             .build());
     *         ctx.export("databaseGatewayGatewayId2", nameRegex.applyValue(getGatewaysResult -> getGatewaysResult.gateways()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:databasegateway:getGateways
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:databasegateway:getGateways
     *       Arguments:
     *         nameRegex: ^my-Gateway
     * outputs:
     *   databaseGatewayGatewayId1: ${ids.gateways[0].id}
     *   databaseGatewayGatewayId2: ${nameRegex.gateways[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGateways.
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(argument: GetGatewaysPlainArgs): GetGatewaysResult =
        toKotlin(getGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getGateways].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Gateway IDs.
     * @param nameRegex A regex string to filter results by Gateway name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param searchKey The search key.
     * @param status The status of gateway. Valid values: `EXCEPTION`, `NEW`, `RUNNING`, `STOPPED`.
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        searchKey: String? = null,
        status: String? = null,
    ): GetGatewaysResult {
        val argument = GetGatewaysPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            searchKey = searchKey,
            status = status,
        )
        return toKotlin(getGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getGateways].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;databasegateway&#46;kotlin&#46;inputs&#46;GetGatewaysPlainArgs].
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(argument: suspend GetGatewaysPlainArgsBuilder.() -> Unit): GetGatewaysResult {
        val builder = GetGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getGatewaysPlain(builtArgument.toJava()).await())
    }
}
