@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Gateway].
 */
@PulumiTagMarker
public class GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayArgs = GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayArgsBuilder.() -> Unit) {
        val builder = GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gateway {
        val builtJavaResource = com.pulumi.alicloud.databasegateway.Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gateway(builtJavaResource)
    }
}

/**
 * Provides a Database Gateway Gateway resource.
 * For information about Database Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/doc-detail/123415.htm).
 * > **NOTE:** Available in v1.135.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.databasegateway.Gateway("example", {gatewayName: "example_value"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.databasegateway.Gateway("example", gateway_name="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.DatabaseGateway.Gateway("example", new()
 *     {
 *         GatewayName = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasegateway.NewGateway(ctx, "example", &databasegateway.GatewayArgs{
 * 			GatewayName: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.databasegateway.Gateway;
 * import com.pulumi.alicloud.databasegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayName("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:databasegateway:Gateway
 *     properties:
 *       gatewayName: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Database Gateway Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasegateway/gateway:Gateway example <id>
 * ```
 */
public class Gateway internal constructor(
    override val javaResource: com.pulumi.alicloud.databasegateway.Gateway,
) : KotlinCustomResource(javaResource, GatewayMapper) {
    /**
     * The description of Gateway.
     */
    public val gatewayDesc: Output<String>?
        get() = javaResource.gatewayDesc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Gateway.
     */
    public val gatewayName: Output<String>
        get() = javaResource.gatewayName().applyValue({ args0 -> args0 })

    /**
     * The status of gateway. Valid values: `EXCEPTION`, `NEW`, `RUNNING`, `STOPPED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object GatewayMapper : ResourceMapper<Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.databasegateway.Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Gateway = Gateway(
        javaResource as
            com.pulumi.alicloud.databasegateway.Gateway,
    )
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gateway].
 */
public suspend fun gateway(name: String, block: suspend GatewayResourceBuilder.() -> Unit): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gateway(name: String): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
