@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasegateway.kotlin

import com.pulumi.alicloud.databasegateway.GatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Database Gateway Gateway resource.
 * For information about Database Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/doc-detail/123415.htm).
 * > **NOTE:** Available in v1.135.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.databasegateway.Gateway("example", {gatewayName: "example_value"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.databasegateway.Gateway("example", gateway_name="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.DatabaseGateway.Gateway("example", new()
 *     {
 *         GatewayName = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/databasegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasegateway.NewGateway(ctx, "example", &databasegateway.GatewayArgs{
 * 			GatewayName: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.databasegateway.Gateway;
 * import com.pulumi.alicloud.databasegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayName("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:databasegateway:Gateway
 *     properties:
 *       gatewayName: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Database Gateway Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:databasegateway/gateway:Gateway example <id>
 * ```
 * @property gatewayDesc The description of Gateway.
 * @property gatewayName The name of the Gateway.
 */
public data class GatewayArgs(
    public val gatewayDesc: Output<String>? = null,
    public val gatewayName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.databasegateway.GatewayArgs> {
    override fun toJava(): com.pulumi.alicloud.databasegateway.GatewayArgs =
        com.pulumi.alicloud.databasegateway.GatewayArgs.builder()
            .gatewayDesc(gatewayDesc?.applyValue({ args0 -> args0 }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var gatewayDesc: Output<String>? = null

    private var gatewayName: Output<String>? = null

    /**
     * @param value The description of Gateway.
     */
    @JvmName("adapytkmftwpgxkm")
    public suspend fun gatewayDesc(`value`: Output<String>) {
        this.gatewayDesc = value
    }

    /**
     * @param value The name of the Gateway.
     */
    @JvmName("whjxlrgbqedfmcyy")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value The description of Gateway.
     */
    @JvmName("xsguleqlkpljknqv")
    public suspend fun gatewayDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayDesc = mapped
    }

    /**
     * @param value The name of the Gateway.
     */
    @JvmName("syodtuukevvrjoij")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        gatewayDesc = gatewayDesc,
        gatewayName = gatewayName,
    )
}
