@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasegateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The creation time of Gateway.
 * @property gatewayDesc The description of Gateway.
 * @property gatewayInstances
 * @property gatewayName The name of the Gateway.
 * @property hosts A host of information.
 * @property id The ID of Gateway.
 * @property modifiedTime The Modify time of Gateway.
 * @property parentId The parent node Id of Gateway.
 * @property status The status of gateway. Valid values: `EXCEPTION`, `NEW`, `RUNNING`, `STOPPED`.
 * @property userId The user's id.
 */
public data class GetGatewaysGateway(
    public val createTime: String,
    public val gatewayDesc: String,
    public val gatewayInstances: List<GetGatewaysGatewayGatewayInstance>,
    public val gatewayName: String,
    public val hosts: String,
    public val id: String,
    public val modifiedTime: String,
    public val parentId: String,
    public val status: String,
    public val userId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.databasegateway.outputs.GetGatewaysGateway): GetGatewaysGateway = GetGatewaysGateway(
            createTime = javaType.createTime(),
            gatewayDesc = javaType.gatewayDesc(),
            gatewayInstances = javaType.gatewayInstances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.databasegateway.kotlin.outputs.GetGatewaysGatewayGatewayInstance.Companion.toKotlin(args0)
                })
            }),
            gatewayName = javaType.gatewayName(),
            hosts = javaType.hosts(),
            id = javaType.id(),
            modifiedTime = javaType.modifiedTime(),
            parentId = javaType.parentId(),
            status = javaType.status(),
            userId = javaType.userId(),
        )
    }
}
