@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.databasegateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectEndpointType The connection type of Gateway instance.
 * @property currentDaemonVersion The process of version number of Gateway instance.
 * @property currentVersion The version of Gateway instance.
 * @property endPoint The endpoint address of Gateway instance.
 * @property gatewayInstanceId The id of Gateway instance.
 * @property gatewayInstanceStatus The status of Gateway instance. Valid values: `EXCEPTION`, `NEW`, `RUNNING`, `STOPPED`.
 * @property lastUpdateTime The last Updated time stamp of Gateway instance.
 * @property localIp The Local IP ADDRESS of Gateway instance.
 * @property message The prompt information of Gateway instance.
 * @property outputIp The host of Gateway instance.
 */
public data class GetGatewaysGatewayGatewayInstance(
    public val connectEndpointType: String,
    public val currentDaemonVersion: String,
    public val currentVersion: String,
    public val endPoint: String,
    public val gatewayInstanceId: String,
    public val gatewayInstanceStatus: String,
    public val lastUpdateTime: String,
    public val localIp: String,
    public val message: String,
    public val outputIp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.databasegateway.outputs.GetGatewaysGatewayGatewayInstance): GetGatewaysGatewayGatewayInstance = GetGatewaysGatewayGatewayInstance(
            connectEndpointType = javaType.connectEndpointType(),
            currentDaemonVersion = javaType.currentDaemonVersion(),
            currentVersion = javaType.currentVersion(),
            endPoint = javaType.endPoint(),
            gatewayInstanceId = javaType.gatewayInstanceId(),
            gatewayInstanceStatus = javaType.gatewayInstanceStatus(),
            lastUpdateTime = javaType.lastUpdateTime(),
            localIp = javaType.localIp(),
            message = javaType.message(),
            outputIp = javaType.outputIp(),
        )
    }
}
