@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.datahub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Project].
 */
@PulumiTagMarker
public class ProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectArgs = ProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectArgsBuilder.() -> Unit) {
        val builder = ProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Project {
        val builtJavaResource = com.pulumi.alicloud.datahub.Project(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Project(builtJavaResource)
    }
}

/**
 * The project is the basic unit of resource management in Datahub Service and is used to isolate and control resources. It contains a set of Topics. You can manage the datahub sources of an application by using projects. [Refer to details](https://www.alibabacloud.com/help/en/datahub/latest/nerbcz).
 * > **NOTE:** Available since v1.19.0.
 * > **NOTE:** Currently Datahub service only can be supported in the regions: cn-beijing, cn-hangzhou, cn-shanghai, cn-shenzhen,  ap-southeast-1.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const example = new alicloud.datahub.Project("example", {
 *     name: name,
 *     comment: "created by terraform",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * example = alicloud.datahub.Project("example",
 *     name=name,
 *     comment="created by terraform")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var example = new AliCloud.Datahub.Project("example", new()
 *     {
 *         Name = name,
 *         Comment = "created by terraform",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/datahub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := datahub.NewProject(ctx, "example", &datahub.ProjectArgs{
 * 			Name:    pulumi.String(name),
 * 			Comment: pulumi.String("created by terraform"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.datahub.Project;
 * import com.pulumi.alicloud.datahub.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(name)
 *             .comment("created by terraform")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   example:
 *     type: alicloud:datahub:Project
 *     properties:
 *       name: ${name}
 *       comment: created by terraform
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Datahub project can be imported using the *name* or ID, e.g.
 * ```sh
 * $ pulumi import alicloud:datahub/project:Project example tf_datahub_project
 * ```
 */
public class Project internal constructor(
    override val javaResource: com.pulumi.alicloud.datahub.Project,
) : KotlinCustomResource(javaResource, ProjectMapper) {
    /**
     * Comment of the datahub project. It cannot be longer than 255 characters.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Create time of the datahub project. It is a human-readable string rather than 64-bits UTC.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Last modify time of the datahub project. It is the same as *create_time* at the beginning. It is also a human-readable string rather than 64-bits UTC.
     */
    public val lastModifyTime: Output<String>
        get() = javaResource.lastModifyTime().applyValue({ args0 -> args0 })

    /**
     * The name of the datahub project. Its length is limited to 3-32 and only characters such as letters, digits and '_' are allowed. It is case-insensitive.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ProjectMapper : ResourceMapper<Project> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.datahub.Project::class == javaResource::class

    override fun map(javaResource: Resource): Project = Project(
        javaResource as
            com.pulumi.alicloud.datahub.Project,
    )
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Project].
 */
public suspend fun project(name: String, block: suspend ProjectResourceBuilder.() -> Unit): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 */
public fun project(name: String): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
