@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.datahub.kotlin

import com.pulumi.alicloud.datahub.TopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The topic is the basic unit of Datahub data source and is used to define one kind of data or stream. It contains a set of subscriptions. You can manage the datahub source of an application by using topics. [Refer to details](https://www.alibabacloud.com/help/en/datahub/latest/nerbcz).
 * > **NOTE:** Available since v1.19.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const example = new alicloud.datahub.Project("example", {
 *     name: name,
 *     comment: "created by terraform",
 * });
 * const exampleBlob = new alicloud.datahub.Topic("example_blob", {
 *     name: `${name}_blob`,
 *     projectName: example.name,
 *     recordType: "BLOB",
 *     shardCount: 3,
 *     lifeCycle: 7,
 *     comment: "created by terraform",
 * });
 * const exampleTuple = new alicloud.datahub.Topic("example_tuple", {
 *     name: `${name}_tuple`,
 *     projectName: example.name,
 *     recordType: "TUPLE",
 *     recordSchema: {
 *         bigint_field: "BIGINT",
 *         timestamp_field: "TIMESTAMP",
 *         string_field: "STRING",
 *         double_field: "DOUBLE",
 *         boolean_field: "BOOLEAN",
 *     },
 *     shardCount: 3,
 *     lifeCycle: 7,
 *     comment: "created by terraform",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * example = alicloud.datahub.Project("example",
 *     name=name,
 *     comment="created by terraform")
 * example_blob = alicloud.datahub.Topic("example_blob",
 *     name=f"{name}_blob",
 *     project_name=example.name,
 *     record_type="BLOB",
 *     shard_count=3,
 *     life_cycle=7,
 *     comment="created by terraform")
 * example_tuple = alicloud.datahub.Topic("example_tuple",
 *     name=f"{name}_tuple",
 *     project_name=example.name,
 *     record_type="TUPLE",
 *     record_schema={
 *         "bigint_field": "BIGINT",
 *         "timestamp_field": "TIMESTAMP",
 *         "string_field": "STRING",
 *         "double_field": "DOUBLE",
 *         "boolean_field": "BOOLEAN",
 *     },
 *     shard_count=3,
 *     life_cycle=7,
 *     comment="created by terraform")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var example = new AliCloud.Datahub.Project("example", new()
 *     {
 *         Name = name,
 *         Comment = "created by terraform",
 *     });
 *     var exampleBlob = new AliCloud.Datahub.Topic("example_blob", new()
 *     {
 *         Name = $"{name}_blob",
 *         ProjectName = example.Name,
 *         RecordType = "BLOB",
 *         ShardCount = 3,
 *         LifeCycle = 7,
 *         Comment = "created by terraform",
 *     });
 *     var exampleTuple = new AliCloud.Datahub.Topic("example_tuple", new()
 *     {
 *         Name = $"{name}_tuple",
 *         ProjectName = example.Name,
 *         RecordType = "TUPLE",
 *         RecordSchema =
 *         {
 *             { "bigint_field", "BIGINT" },
 *             { "timestamp_field", "TIMESTAMP" },
 *             { "string_field", "STRING" },
 *             { "double_field", "DOUBLE" },
 *             { "boolean_field", "BOOLEAN" },
 *         },
 *         ShardCount = 3,
 *         LifeCycle = 7,
 *         Comment = "created by terraform",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/datahub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := datahub.NewProject(ctx, "example", &datahub.ProjectArgs{
 * 			Name:    pulumi.String(name),
 * 			Comment: pulumi.String("created by terraform"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = datahub.NewTopic(ctx, "example_blob", &datahub.TopicArgs{
 * 			Name:        pulumi.Sprintf("%v_blob", name),
 * 			ProjectName: example.Name,
 * 			RecordType:  pulumi.String("BLOB"),
 * 			ShardCount:  pulumi.Int(3),
 * 			LifeCycle:   pulumi.Int(7),
 * 			Comment:     pulumi.String("created by terraform"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = datahub.NewTopic(ctx, "example_tuple", &datahub.TopicArgs{
 * 			Name:        pulumi.Sprintf("%v_tuple", name),
 * 			ProjectName: example.Name,
 * 			RecordType:  pulumi.String("TUPLE"),
 * 			RecordSchema: pulumi.StringMap{
 * 				"bigint_field":    pulumi.String("BIGINT"),
 * 				"timestamp_field": pulumi.String("TIMESTAMP"),
 * 				"string_field":    pulumi.String("STRING"),
 * 				"double_field":    pulumi.String("DOUBLE"),
 * 				"boolean_field":   pulumi.String("BOOLEAN"),
 * 			},
 * 			ShardCount: pulumi.Int(3),
 * 			LifeCycle:  pulumi.Int(7),
 * 			Comment:    pulumi.String("created by terraform"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.datahub.Project;
 * import com.pulumi.alicloud.datahub.ProjectArgs;
 * import com.pulumi.alicloud.datahub.Topic;
 * import com.pulumi.alicloud.datahub.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(name)
 *             .comment("created by terraform")
 *             .build());
 *         var exampleBlob = new Topic("exampleBlob", TopicArgs.builder()
 *             .name(String.format("%s_blob", name))
 *             .projectName(example.name())
 *             .recordType("BLOB")
 *             .shardCount(3)
 *             .lifeCycle(7)
 *             .comment("created by terraform")
 *             .build());
 *         var exampleTuple = new Topic("exampleTuple", TopicArgs.builder()
 *             .name(String.format("%s_tuple", name))
 *             .projectName(example.name())
 *             .recordType("TUPLE")
 *             .recordSchema(Map.ofEntries(
 *                 Map.entry("bigint_field", "BIGINT"),
 *                 Map.entry("timestamp_field", "TIMESTAMP"),
 *                 Map.entry("string_field", "STRING"),
 *                 Map.entry("double_field", "DOUBLE"),
 *                 Map.entry("boolean_field", "BOOLEAN")
 *             ))
 *             .shardCount(3)
 *             .lifeCycle(7)
 *             .comment("created by terraform")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   example:
 *     type: alicloud:datahub:Project
 *     properties:
 *       name: ${name}
 *       comment: created by terraform
 *   exampleBlob:
 *     type: alicloud:datahub:Topic
 *     name: example_blob
 *     properties:
 *       name: ${name}_blob
 *       projectName: ${example.name}
 *       recordType: BLOB
 *       shardCount: 3
 *       lifeCycle: 7
 *       comment: created by terraform
 *   exampleTuple:
 *     type: alicloud:datahub:Topic
 *     name: example_tuple
 *     properties:
 *       name: ${name}_tuple
 *       projectName: ${example.name}
 *       recordType: TUPLE
 *       recordSchema:
 *         bigint_field: BIGINT
 *         timestamp_field: TIMESTAMP
 *         string_field: STRING
 *         double_field: DOUBLE
 *         boolean_field: BOOLEAN
 *       shardCount: 3
 *       lifeCycle: 7
 *       comment: created by terraform
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Datahub topic can be imported using the ID, e.g.
 * ```sh
 * $ pulumi import alicloud:datahub/topic:Topic example tf_datahub_project:tf_datahub_topic
 * ```
 * @property comment Comment of the datahub topic. It cannot be longer than 255 characters.
 * **Notes:** Currently `life_cycle` can not be modified and it will be supported in the next future.
 * @property lifeCycle How many days this topic lives. The permitted range of values is [1, 7]. The default value is 3.
 * @property name The name of the datahub topic. Its length is limited to 1-128 and only characters such as letters, digits and '_' are allowed. It is case-insensitive.
 * @property projectName The name of the datahub project that this topic belongs to. It is case-insensitive.
 * @property recordSchema Schema of this topic, required only for TUPLE topic. Supported data types (case-insensitive) are:
 * - BIGINT
 * - STRING
 * - BOOLEAN
 * - DOUBLE
 * - TIMESTAMP
 * @property recordType The type of this topic. Its value must be one of {BLOB, TUPLE}. For BLOB topic, data will be organized as binary and encoded by BASE64. For TUPLE topic, data has fixed schema. The default value is "TUPLE" with a schema {STRING}.
 * @property shardCount The number of shards this topic contains. The permitted range of values is [1, 10]. The default value is 1.
 */
public data class TopicArgs(
    public val comment: Output<String>? = null,
    public val lifeCycle: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val recordSchema: Output<Map<String, String>>? = null,
    public val recordType: Output<String>? = null,
    public val shardCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.datahub.TopicArgs> {
    override fun toJava(): com.pulumi.alicloud.datahub.TopicArgs =
        com.pulumi.alicloud.datahub.TopicArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .lifeCycle(lifeCycle?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .recordSchema(
                recordSchema?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .recordType(recordType?.applyValue({ args0 -> args0 }))
            .shardCount(shardCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicArgs].
 */
@PulumiTagMarker
public class TopicArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var lifeCycle: Output<Int>? = null

    private var name: Output<String>? = null

    private var projectName: Output<String>? = null

    private var recordSchema: Output<Map<String, String>>? = null

    private var recordType: Output<String>? = null

    private var shardCount: Output<Int>? = null

    /**
     * @param value Comment of the datahub topic. It cannot be longer than 255 characters.
     * **Notes:** Currently `life_cycle` can not be modified and it will be supported in the next future.
     */
    @JvmName("ltjpvxbnouhbimji")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value How many days this topic lives. The permitted range of values is [1, 7]. The default value is 3.
     */
    @JvmName("npwofyhgpbocuwff")
    public suspend fun lifeCycle(`value`: Output<Int>) {
        this.lifeCycle = value
    }

    /**
     * @param value The name of the datahub topic. Its length is limited to 1-128 and only characters such as letters, digits and '_' are allowed. It is case-insensitive.
     */
    @JvmName("ijrgisjdkcfkecqo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the datahub project that this topic belongs to. It is case-insensitive.
     */
    @JvmName("fkrfstkbadnuccvs")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Schema of this topic, required only for TUPLE topic. Supported data types (case-insensitive) are:
     * - BIGINT
     * - STRING
     * - BOOLEAN
     * - DOUBLE
     * - TIMESTAMP
     */
    @JvmName("pnmopjxyvxbfdrtl")
    public suspend fun recordSchema(`value`: Output<Map<String, String>>) {
        this.recordSchema = value
    }

    /**
     * @param value The type of this topic. Its value must be one of {BLOB, TUPLE}. For BLOB topic, data will be organized as binary and encoded by BASE64. For TUPLE topic, data has fixed schema. The default value is "TUPLE" with a schema {STRING}.
     */
    @JvmName("xwjmlhrydeehmjlg")
    public suspend fun recordType(`value`: Output<String>) {
        this.recordType = value
    }

    /**
     * @param value The number of shards this topic contains. The permitted range of values is [1, 10]. The default value is 1.
     */
    @JvmName("fllglnguxmlrqris")
    public suspend fun shardCount(`value`: Output<Int>) {
        this.shardCount = value
    }

    /**
     * @param value Comment of the datahub topic. It cannot be longer than 255 characters.
     * **Notes:** Currently `life_cycle` can not be modified and it will be supported in the next future.
     */
    @JvmName("jeouloskvyxkuntw")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value How many days this topic lives. The permitted range of values is [1, 7]. The default value is 3.
     */
    @JvmName("njigxgoeivdailec")
    public suspend fun lifeCycle(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifeCycle = mapped
    }

    /**
     * @param value The name of the datahub topic. Its length is limited to 1-128 and only characters such as letters, digits and '_' are allowed. It is case-insensitive.
     */
    @JvmName("pbxvaqgdwqtshqry")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the datahub project that this topic belongs to. It is case-insensitive.
     */
    @JvmName("pbjohxwxxbtpsxwn")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Schema of this topic, required only for TUPLE topic. Supported data types (case-insensitive) are:
     * - BIGINT
     * - STRING
     * - BOOLEAN
     * - DOUBLE
     * - TIMESTAMP
     */
    @JvmName("okgswsplpogvykqf")
    public suspend fun recordSchema(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordSchema = mapped
    }

    /**
     * @param values Schema of this topic, required only for TUPLE topic. Supported data types (case-insensitive) are:
     * - BIGINT
     * - STRING
     * - BOOLEAN
     * - DOUBLE
     * - TIMESTAMP
     */
    @JvmName("ddwmyliomqxwglok")
    public fun recordSchema(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordSchema = mapped
    }

    /**
     * @param value The type of this topic. Its value must be one of {BLOB, TUPLE}. For BLOB topic, data will be organized as binary and encoded by BASE64. For TUPLE topic, data has fixed schema. The default value is "TUPLE" with a schema {STRING}.
     */
    @JvmName("mwxgpqdvkmupfwjn")
    public suspend fun recordType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordType = mapped
    }

    /**
     * @param value The number of shards this topic contains. The permitted range of values is [1, 10]. The default value is 1.
     */
    @JvmName("nqxmonmcogwcjulo")
    public suspend fun shardCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardCount = mapped
    }

    internal fun build(): TopicArgs = TopicArgs(
        comment = comment,
        lifeCycle = lifeCycle,
        name = name,
        projectName = projectName,
        recordSchema = recordSchema,
        recordType = recordType,
        shardCount = shardCount,
    )
}
