@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dataworks.kotlin

import com.pulumi.alicloud.dataworks.DataworksFunctions.getFoldersPlain
import com.pulumi.alicloud.dataworks.DataworksFunctions.getServicePlain
import com.pulumi.alicloud.dataworks.kotlin.inputs.GetFoldersPlainArgs
import com.pulumi.alicloud.dataworks.kotlin.inputs.GetFoldersPlainArgsBuilder
import com.pulumi.alicloud.dataworks.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.dataworks.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.dataworks.kotlin.outputs.GetFoldersResult
import com.pulumi.alicloud.dataworks.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.dataworks.kotlin.outputs.GetFoldersResult.Companion.toKotlin as getFoldersResultToKotlin
import com.pulumi.alicloud.dataworks.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object DataworksFunctions {
    /**
     * This data source provides the Data Works Folders of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.131.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const _default = new alicloud.dataworks.Folder("default", {
     *     projectId: "xxxx",
     *     folderPath: "Business Flow/tfTestAcc/folderDi",
     * });
     * const ids = pulumi.all([_default&#46;folderId, _default&#46;projectId])&#46;apply(([folderId, projectId]) => alicloud.dataworks.getFoldersOutput({
     *     ids: [folderId],
     *     projectId: projectId,
     *     parentFolderPath: "Business Flow/tfTestAcc/folderDi",
     * }));
     * export const dataWorksFolderId1 = ids.apply(ids => ids.folders?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.dataworks.Folder("default",
     *     project_id="xxxx",
     *     folder_path="Business Flow/tfTestAcc/folderDi")
     * ids = pulumi.Output.all(
     *     folder_id=default.folder_id,
     *     project_id=default.project_id
     * ).apply(lambda resolved_outputs: alicloud.dataworks.get_folders_output(ids=[resolved_outputs['folder_id']],
     *     project_id=resolved_outputs['project_id'],
     *     parent_folder_path="Business Flow/tfTestAcc/folderDi"))
     * pulumi.export("dataWorksFolderId1", ids.folders[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = new AliCloud.DataWorks.Folder("default", new()
     *     {
     *         ProjectId = "xxxx",
     *         FolderPath = "Business Flow/tfTestAcc/folderDi",
     *     });
     *     var ids = AliCloud.DataWorks.GetFolders.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             @default.FolderId,
     *         },
     *         ProjectId = @default.ProjectId,
     *         ParentFolderPath = "Business Flow/tfTestAcc/folderDi",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dataWorksFolderId1"] = ids&#46;Apply(getFoldersResult => getFoldersResult&#46;Folders[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dataworks"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := dataworks.NewFolder(ctx, "default", &dataworks.FolderArgs{
     * 			ProjectId:  pulumi.String("xxxx"),
     * 			FolderPath: pulumi.String("Business Flow/tfTestAcc/folderDi"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := pulumi.All(_default.FolderId, _default.ProjectId).ApplyT(func(_args []interface{}) (dataworks.GetFoldersResult, error) {
     * 			folderId := _args[0].(string)
     * 			projectId := _args[1].(*string)
     * 			return dataworks.GetFoldersResult(interface{}(dataworks.GetFoldersOutput(ctx, dataworks.GetFoldersOutputArgs{
     * 				Ids: []string{
     * 					folderId,
     * 				},
     * 				ProjectId:        projectId,
     * 				ParentFolderPath: "Business Flow/tfTestAcc/folderDi",
     * 			}, nil))), nil
     * 		}).(dataworks.GetFoldersResultOutput)
     * 		ctx.Export("dataWorksFolderId1", ids.ApplyT(func(ids dataworks.GetFoldersResult) (*string, error) {
     * 			return &ids.Folders[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dataworks.Folder;
     * import com.pulumi.alicloud.dataworks.FolderArgs;
     * import com.pulumi.alicloud.dataworks.DataworksFunctions;
     * import com.pulumi.alicloud.dataworks.inputs.GetFoldersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var default_ = new Folder("default", FolderArgs.builder()
     *             .projectId("xxxx")
     *             .folderPath("Business Flow/tfTestAcc/folderDi")
     *             .build());
     *         final var ids = DataworksFunctions.getFolders(GetFoldersArgs.builder()
     *             .ids(default_.folderId())
     *             .projectId(default_.projectId())
     *             .parentFolderPath("Business Flow/tfTestAcc/folderDi")
     *             .build());
     *         ctx.export("dataWorksFolderId1", ids.applyValue(getFoldersResult -> getFoldersResult).applyValue(ids -> ids.applyValue(getFoldersResult -> getFoldersResult.folders()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:dataworks:Folder
     *     properties:
     *       projectId: xxxx
     *       folderPath: Business Flow/tfTestAcc/folderDi
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dataworks:getFolders
     *       Arguments:
     *         ids:
     *           - ${default.folderId}
     *         projectId: ${default.projectId}
     *         parentFolderPath: Business Flow/tfTestAcc/folderDi
     * outputs:
     *   dataWorksFolderId1: ${ids.folders[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFolders.
     * @return A collection of values returned by getFolders.
     */
    public suspend fun getFolders(argument: GetFoldersPlainArgs): GetFoldersResult =
        getFoldersResultToKotlin(getFoldersPlain(argument.toJava()).await())

    /**
     * @see [getFolders].
     * @param ids A list of Folder IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param parentFolderPath The parent folder path.
     * @param projectId The ID of the project.
     * @return A collection of values returned by getFolders.
     */
    public suspend fun getFolders(
        ids: List<String>? = null,
        outputFile: String? = null,
        parentFolderPath: String,
        projectId: String,
    ): GetFoldersResult {
        val argument = GetFoldersPlainArgs(
            ids = ids,
            outputFile = outputFile,
            parentFolderPath = parentFolderPath,
            projectId = projectId,
        )
        return getFoldersResultToKotlin(getFoldersPlain(argument.toJava()).await())
    }

    /**
     * @see [getFolders].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dataworks&#46;kotlin&#46;inputs&#46;GetFoldersPlainArgs].
     * @return A collection of values returned by getFolders.
     */
    public suspend fun getFolders(argument: suspend GetFoldersPlainArgsBuilder.() -> Unit): GetFoldersResult {
        val builder = GetFoldersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFoldersResultToKotlin(getFoldersPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open DataWorks service automatically. If the service has been opened, it will return opened.
     * For information about DataWorks and how to use it, see [What is DataWorks](https://www.alibabacloud.com/help/en/product/72772.htm).
     * > **NOTE:** Available in v1.118.0+. After the version 1.141.0, the data source is renamed as `alicloud.dataworks.getService`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.dataworks.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.dataworks.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.DataWorks.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dataworks"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := dataworks.GetService(ctx, &dataworks.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dataworks.DataworksFunctions;
     * import com.pulumi.alicloud.dataworks.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = DataworksFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:dataworks:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the DataWorks service that means you have read and agreed the [DataWorks Terms of Service](https://help.aliyun.com/document_detail/131538.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dataworks&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
