@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dataworks.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Folder].
 */
@PulumiTagMarker
public class FolderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FolderArgs = FolderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FolderArgsBuilder.() -> Unit) {
        val builder = FolderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Folder {
        val builtJavaResource = com.pulumi.alicloud.dataworks.Folder(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Folder(builtJavaResource)
    }
}

/**
 * Provides a Data Works Folder resource.
 * For information about Data Works Folder and how to use it, see [What is Folder](https://help.aliyun.com/document_detail/173940.html).
 * > **NOTE:** Available in v1.131.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.dataworks.Folder("example", {
 *     projectId: "320687",
 *     folderPath: "Business Flow/tfTestAcc/folderDi/tftest1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.dataworks.Folder("example",
 *     project_id="320687",
 *     folder_path="Business Flow/tfTestAcc/folderDi/tftest1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.DataWorks.Folder("example", new()
 *     {
 *         ProjectId = "320687",
 *         FolderPath = "Business Flow/tfTestAcc/folderDi/tftest1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dataworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dataworks.NewFolder(ctx, "example", &dataworks.FolderArgs{
 * 			ProjectId:  pulumi.String("320687"),
 * 			FolderPath: pulumi.String("Business Flow/tfTestAcc/folderDi/tftest1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dataworks.Folder;
 * import com.pulumi.alicloud.dataworks.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Folder("example", FolderArgs.builder()
 *             .projectId("320687")
 *             .folderPath("Business Flow/tfTestAcc/folderDi/tftest1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:dataworks:Folder
 *     properties:
 *       projectId: '320687'
 *       folderPath: Business Flow/tfTestAcc/folderDi/tftest1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Works Folder can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dataworks/folder:Folder example <folder_id>:<$.ProjectId>
 * ```
 */
public class Folder internal constructor(
    override val javaResource: com.pulumi.alicloud.dataworks.Folder,
) : KotlinCustomResource(javaResource, FolderMapper) {
    public val folderId: Output<String>
        get() = javaResource.folderId().applyValue({ args0 -> args0 })

    /**
     * Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
     */
    public val folderPath: Output<String>
        get() = javaResource.folderPath().applyValue({ args0 -> args0 })

    /**
     * The ID of the project.
     */
    public val projectId: Output<String>?
        get() = javaResource.projectId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val projectIdentifier: Output<String>?
        get() = javaResource.projectIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object FolderMapper : ResourceMapper<Folder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dataworks.Folder::class == javaResource::class

    override fun map(javaResource: Resource): Folder = Folder(
        javaResource as
            com.pulumi.alicloud.dataworks.Folder,
    )
}

/**
 * @see [Folder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Folder].
 */
public suspend fun folder(name: String, block: suspend FolderResourceBuilder.() -> Unit): Folder {
    val builder = FolderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Folder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun folder(name: String): Folder {
    val builder = FolderResourceBuilder()
    builder.name(name)
    return builder.build()
}
