@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dataworks.kotlin

import com.pulumi.alicloud.dataworks.FolderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Data Works Folder resource.
 * For information about Data Works Folder and how to use it, see [What is Folder](https://help.aliyun.com/document_detail/173940.html).
 * > **NOTE:** Available in v1.131.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.dataworks.Folder("example", {
 *     projectId: "320687",
 *     folderPath: "Business Flow/tfTestAcc/folderDi/tftest1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.dataworks.Folder("example",
 *     project_id="320687",
 *     folder_path="Business Flow/tfTestAcc/folderDi/tftest1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.DataWorks.Folder("example", new()
 *     {
 *         ProjectId = "320687",
 *         FolderPath = "Business Flow/tfTestAcc/folderDi/tftest1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dataworks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dataworks.NewFolder(ctx, "example", &dataworks.FolderArgs{
 * 			ProjectId:  pulumi.String("320687"),
 * 			FolderPath: pulumi.String("Business Flow/tfTestAcc/folderDi/tftest1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dataworks.Folder;
 * import com.pulumi.alicloud.dataworks.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Folder("example", FolderArgs.builder()
 *             .projectId("320687")
 *             .folderPath("Business Flow/tfTestAcc/folderDi/tftest1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:dataworks:Folder
 *     properties:
 *       projectId: '320687'
 *       folderPath: Business Flow/tfTestAcc/folderDi/tftest1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Works Folder can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dataworks/folder:Folder example <folder_id>:<$.ProjectId>
 * ```
 * @property folderPath Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
 * @property projectId The ID of the project.
 * @property projectIdentifier
 */
public data class FolderArgs(
    public val folderPath: Output<String>? = null,
    public val projectId: Output<String>? = null,
    public val projectIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dataworks.FolderArgs> {
    override fun toJava(): com.pulumi.alicloud.dataworks.FolderArgs =
        com.pulumi.alicloud.dataworks.FolderArgs.builder()
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .projectId(projectId?.applyValue({ args0 -> args0 }))
            .projectIdentifier(projectIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FolderArgs].
 */
@PulumiTagMarker
public class FolderArgsBuilder internal constructor() {
    private var folderPath: Output<String>? = null

    private var projectId: Output<String>? = null

    private var projectIdentifier: Output<String>? = null

    /**
     * @param value Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
     */
    @JvmName("ypjvickglygycudd")
    public suspend fun folderPath(`value`: Output<String>) {
        this.folderPath = value
    }

    /**
     * @param value The ID of the project.
     */
    @JvmName("ovufmtgjwsrqgidx")
    public suspend fun projectId(`value`: Output<String>) {
        this.projectId = value
    }

    /**
     * @param value
     */
    @JvmName("bufatfyflyqhynrr")
    public suspend fun projectIdentifier(`value`: Output<String>) {
        this.projectIdentifier = value
    }

    /**
     * @param value Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
     */
    @JvmName("lenrcutvpasoiotq")
    public suspend fun folderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value The ID of the project.
     */
    @JvmName("rktsspfjvkssbofe")
    public suspend fun projectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectId = mapped
    }

    /**
     * @param value
     */
    @JvmName("shdqfyckoqvqufir")
    public suspend fun projectIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectIdentifier = mapped
    }

    internal fun build(): FolderArgs = FolderArgs(
        folderPath = folderPath,
        projectId = projectId,
        projectIdentifier = projectIdentifier,
    )
}
