@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dataworks.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Project].
 */
@PulumiTagMarker
public class ProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectArgs = ProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectArgsBuilder.() -> Unit) {
        val builder = ProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Project {
        val builtJavaResource = com.pulumi.alicloud.dataworks.Project(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Project(builtJavaResource)
    }
}

/**
 * Provides a Data Works Project resource.
 * For information about Data Works Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2020-05-18-createproject).
 * > **NOTE:** Available since v1.229.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultProject = new alicloud.dataworks.Project("default", {
 *     projectName: `${name}_${_default.result}`,
 *     projectMode: 2,
 *     description: `${name}_${_default.result}`,
 *     displayName: `${name}_${_default.result}`,
 *     status: "0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_project = alicloud.dataworks.Project("default",
 *     project_name=f"{name}_{default['result']}",
 *     project_mode=2,
 *     description=f"{name}_{default['result']}",
 *     display_name=f"{name}_{default['result']}",
 *     status="0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultProject = new AliCloud.DataWorks.Project("default", new()
 *     {
 *         ProjectName = $"{name}_{@default.Result}",
 *         ProjectMode = 2,
 *         Description = $"{name}_{@default.Result}",
 *         DisplayName = $"{name}_{@default.Result}",
 *         Status = "0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dataworks"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dataworks.NewProject(ctx, "default", &dataworks.ProjectArgs{
 * 			ProjectName: pulumi.Sprintf("%v_%v", name, _default.Result),
 * 			ProjectMode: pulumi.Int(2),
 * 			Description: pulumi.Sprintf("%v_%v", name, _default.Result),
 * 			DisplayName: pulumi.Sprintf("%v_%v", name, _default.Result),
 * 			Status:      pulumi.String("0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dataworks.Project;
 * import com.pulumi.alicloud.dataworks.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultProject = new Project("defaultProject", ProjectArgs.builder()
 *             .projectName(String.format("%s_%s", name,default_.result()))
 *             .projectMode("2")
 *             .description(String.format("%s_%s", name,default_.result()))
 *             .displayName(String.format("%s_%s", name,default_.result()))
 *             .status("0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultProject:
 *     type: alicloud:dataworks:Project
 *     name: default
 *     properties:
 *       projectName: ${name}_${default.result}
 *       projectMode: '2'
 *       description: ${name}_${default.result}
 *       displayName: ${name}_${default.result}
 *       status: '0'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Works Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dataworks/project:Project example <id>
 * ```
 */
public class Project internal constructor(
    override val javaResource: com.pulumi.alicloud.dataworks.Project,
) : KotlinCustomResource(javaResource, ProjectMapper) {
    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description of the workspace
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The display name of the workspace.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The mode of the workspace, with the following values:
     * - 2, indicates the simple workspace mode.
     * - 3, indicating the standard workspace mode.
     */
    public val projectMode: Output<Int>?
        get() = javaResource.projectMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Immutable Name of the workspace.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ProjectMapper : ResourceMapper<Project> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dataworks.Project::class == javaResource::class

    override fun map(javaResource: Resource): Project = Project(
        javaResource as
            com.pulumi.alicloud.dataworks.Project,
    )
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Project].
 */
public suspend fun project(name: String, block: suspend ProjectResourceBuilder.() -> Unit): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 */
public fun project(name: String): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
