@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dataworks.kotlin

import com.pulumi.alicloud.dataworks.ProjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Data Works Project resource.
 * For information about Data Works Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2020-05-18-createproject).
 * > **NOTE:** Available since v1.229.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultProject = new alicloud.dataworks.Project("default", {
 *     projectName: `${name}_${_default.result}`,
 *     projectMode: 2,
 *     description: `${name}_${_default.result}`,
 *     displayName: `${name}_${_default.result}`,
 *     status: "0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_project = alicloud.dataworks.Project("default",
 *     project_name=f"{name}_{default['result']}",
 *     project_mode=2,
 *     description=f"{name}_{default['result']}",
 *     display_name=f"{name}_{default['result']}",
 *     status="0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultProject = new AliCloud.DataWorks.Project("default", new()
 *     {
 *         ProjectName = $"{name}_{@default.Result}",
 *         ProjectMode = 2,
 *         Description = $"{name}_{@default.Result}",
 *         DisplayName = $"{name}_{@default.Result}",
 *         Status = "0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dataworks"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dataworks.NewProject(ctx, "default", &dataworks.ProjectArgs{
 * 			ProjectName: pulumi.Sprintf("%v_%v", name, _default.Result),
 * 			ProjectMode: pulumi.Int(2),
 * 			Description: pulumi.Sprintf("%v_%v", name, _default.Result),
 * 			DisplayName: pulumi.Sprintf("%v_%v", name, _default.Result),
 * 			Status:      pulumi.String("0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dataworks.Project;
 * import com.pulumi.alicloud.dataworks.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultProject = new Project("defaultProject", ProjectArgs.builder()
 *             .projectName(String.format("%s_%s", name,default_.result()))
 *             .projectMode("2")
 *             .description(String.format("%s_%s", name,default_.result()))
 *             .displayName(String.format("%s_%s", name,default_.result()))
 *             .status("0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultProject:
 *     type: alicloud:dataworks:Project
 *     name: default
 *     properties:
 *       projectName: ${name}_${default.result}
 *       projectMode: '2'
 *       description: ${name}_${default.result}
 *       displayName: ${name}_${default.result}
 *       status: '0'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Works Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dataworks/project:Project example <id>
 * ```
 * @property description Description of the workspace
 * @property displayName The display name of the workspace.
 * @property projectMode The mode of the workspace, with the following values:
 * - 2, indicates the simple workspace mode.
 * - 3, indicating the standard workspace mode.
 * @property projectName Immutable Name of the workspace.
 * @property status The status of the resource
 */
public data class ProjectArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val projectMode: Output<Int>? = null,
    public val projectName: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dataworks.ProjectArgs> {
    override fun toJava(): com.pulumi.alicloud.dataworks.ProjectArgs =
        com.pulumi.alicloud.dataworks.ProjectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .projectMode(projectMode?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var projectMode: Output<Int>? = null

    private var projectName: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Description of the workspace
     */
    @JvmName("owrslhqutoiunbln")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the workspace.
     */
    @JvmName("oyjwlnawtmtfqcdg")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The mode of the workspace, with the following values:
     * - 2, indicates the simple workspace mode.
     * - 3, indicating the standard workspace mode.
     */
    @JvmName("puudhullbfgqlvfg")
    public suspend fun projectMode(`value`: Output<Int>) {
        this.projectMode = value
    }

    /**
     * @param value Immutable Name of the workspace.
     */
    @JvmName("ijunadhacubymyug")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the resource
     */
    @JvmName("fxqhxogykuuolvly")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Description of the workspace
     */
    @JvmName("aleldglaxbdenjug")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the workspace.
     */
    @JvmName("xoaxvdugdndohvjp")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The mode of the workspace, with the following values:
     * - 2, indicates the simple workspace mode.
     * - 3, indicating the standard workspace mode.
     */
    @JvmName("qtmnlhuxwpdfkglf")
    public suspend fun projectMode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectMode = mapped
    }

    /**
     * @param value Immutable Name of the workspace.
     */
    @JvmName("fknnjsfqkajiqboh")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the resource
     */
    @JvmName("drjovjbhufarpsiu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        description = description,
        displayName = displayName,
        projectMode = projectMode,
        projectName = projectName,
        status = status,
    )
}
