@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dataworks.kotlin.inputs

import com.pulumi.alicloud.dataworks.inputs.GetFoldersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFolders.
 * @property ids A list of Folder IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property parentFolderPath The parent folder path.
 * @property projectId The ID of the project.
 */
public data class GetFoldersPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val parentFolderPath: String,
    public val projectId: String,
) : ConvertibleToJava<com.pulumi.alicloud.dataworks.inputs.GetFoldersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dataworks.inputs.GetFoldersPlainArgs =
        com.pulumi.alicloud.dataworks.inputs.GetFoldersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .parentFolderPath(parentFolderPath.let({ args0 -> args0 }))
            .projectId(projectId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFoldersPlainArgs].
 */
@PulumiTagMarker
public class GetFoldersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var parentFolderPath: String? = null

    private var projectId: String? = null

    /**
     * @param value A list of Folder IDs.
     */
    @JvmName("tsnysplkhkfftahx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Folder IDs.
     */
    @JvmName("hikfqurrywntnfkq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qcecwypipjxtfhlf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The parent folder path.
     */
    @JvmName("gfcmnbyejogrnqrk")
    public suspend fun parentFolderPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentFolderPath = mapped
    }

    /**
     * @param value The ID of the project.
     */
    @JvmName("abovlimhafcfqxqr")
    public suspend fun projectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectId = mapped
    }

    internal fun build(): GetFoldersPlainArgs = GetFoldersPlainArgs(
        ids = ids,
        outputFile = outputFile,
        parentFolderPath = parentFolderPath ?: throw PulumiNullFieldException("parentFolderPath"),
        projectId = projectId ?: throw PulumiNullFieldException("projectId"),
    )
}
