@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dataworks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFolders.
 * @property folders
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property parentFolderPath
 * @property projectId
 */
public data class GetFoldersResult(
    public val folders: List<GetFoldersFolder>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val parentFolderPath: String,
    public val projectId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dataworks.outputs.GetFoldersResult): GetFoldersResult = GetFoldersResult(
            folders = javaType.folders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dataworks.kotlin.outputs.GetFoldersFolder.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            parentFolderPath = javaType.parentFolderPath(),
            projectId = javaType.projectId(),
        )
    }
}
