@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dbs.kotlin

import com.pulumi.alicloud.dbs.DbsFunctions.getBackupPlansPlain
import com.pulumi.alicloud.dbs.kotlin.inputs.GetBackupPlansPlainArgs
import com.pulumi.alicloud.dbs.kotlin.inputs.GetBackupPlansPlainArgsBuilder
import com.pulumi.alicloud.dbs.kotlin.outputs.GetBackupPlansResult
import com.pulumi.alicloud.dbs.kotlin.outputs.GetBackupPlansResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object DbsFunctions {
    /**
     * This data source provides the Dbs Backup Plans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.185.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dbs.getBackupPlans({});
     * export const dbsBackupPlanId1 = ids.then(ids => ids.plans?.[0]?.id);
     * const nameRegex = alicloud.dbs.getBackupPlans({
     *     nameRegex: "^my-BackupPlan",
     * });
     * export const dbsBackupPlanId2 = nameRegex.then(nameRegex => nameRegex.plans?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dbs.get_backup_plans()
     * pulumi.export("dbsBackupPlanId1", ids.plans[0].id)
     * name_regex = alicloud.dbs.get_backup_plans(name_regex="^my-BackupPlan")
     * pulumi.export("dbsBackupPlanId2", name_regex.plans[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.DBS.GetBackupPlans.Invoke();
     *     var nameRegex = AliCloud.DBS.GetBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "^my-BackupPlan",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dbsBackupPlanId1"] = ids&#46;Apply(getBackupPlansResult => getBackupPlansResult&#46;Plans[0]?.Id),
     *         ["dbsBackupPlanId2"] = nameRegex&#46;Apply(getBackupPlansResult => getBackupPlansResult&#46;Plans[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dbs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dbs.GetBackupPlans(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dbsBackupPlanId1", ids.Plans[0].Id)
     * 		nameRegex, err := dbs.GetBackupPlans(ctx, &dbs.GetBackupPlansArgs{
     * 			NameRegex: pulumi.StringRef("^my-BackupPlan"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dbsBackupPlanId2", nameRegex.Plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dbs.DbsFunctions;
     * import com.pulumi.alicloud.dbs.inputs.GetBackupPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DbsFunctions.getBackupPlans();
     *         ctx.export("dbsBackupPlanId1", ids.applyValue(getBackupPlansResult -> getBackupPlansResult.plans()[0].id()));
     *         final var nameRegex = DbsFunctions.getBackupPlans(GetBackupPlansArgs.builder()
     *             .nameRegex("^my-BackupPlan")
     *             .build());
     *         ctx.export("dbsBackupPlanId2", nameRegex.applyValue(getBackupPlansResult -> getBackupPlansResult.plans()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dbs:getBackupPlans
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:dbs:getBackupPlans
     *       Arguments:
     *         nameRegex: ^my-BackupPlan
     * outputs:
     *   dbsBackupPlanId1: ${ids.plans[0].id}
     *   dbsBackupPlanId2: ${nameRegex.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBackupPlans.
     * @return A collection of values returned by getBackupPlans.
     */
    public suspend fun getBackupPlans(argument: GetBackupPlansPlainArgs): GetBackupPlansResult =
        toKotlin(getBackupPlansPlain(argument.toJava()).await())

    /**
     * @see [getBackupPlans].
     * @param backupPlanName The name of the resource.
     * @param enableDetails Default to `true`. Set it to `false` can hide the `payment_type` to output.
     * @param ids A list of Backup Plan IDs.
     * @param nameRegex A regex string to filter results by Backup Plan name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the resource. Valid values: `check_pass`, `init`, `locked`, `pause`, `running`, `stop`, `wait`.
     * @return A collection of values returned by getBackupPlans.
     */
    public suspend fun getBackupPlans(
        backupPlanName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetBackupPlansResult {
        val argument = GetBackupPlansPlainArgs(
            backupPlanName = backupPlanName,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return toKotlin(getBackupPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dbs&#46;kotlin&#46;inputs&#46;GetBackupPlansPlainArgs].
     * @return A collection of values returned by getBackupPlans.
     */
    public suspend fun getBackupPlans(argument: suspend GetBackupPlansPlainArgsBuilder.() -> Unit): GetBackupPlansResult {
        val builder = GetBackupPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getBackupPlansPlain(builtArgument.toJava()).await())
    }
}
