@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dbs.kotlin.inputs

import com.pulumi.alicloud.dbs.inputs.GetBackupPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBackupPlans.
 * @property backupPlanName The name of the resource.
 * @property enableDetails Default to `true`. Set it to `false` can hide the `payment_type` to output.
 * @property ids A list of Backup Plan IDs.
 * @property nameRegex A regex string to filter results by Backup Plan name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The status of the resource. Valid values: `check_pass`, `init`, `locked`, `pause`, `running`, `stop`, `wait`.
 */
public data class GetBackupPlansPlainArgs(
    public val backupPlanName: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dbs.inputs.GetBackupPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dbs.inputs.GetBackupPlansPlainArgs =
        com.pulumi.alicloud.dbs.inputs.GetBackupPlansPlainArgs.builder()
            .backupPlanName(backupPlanName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupPlansPlainArgs].
 */
@PulumiTagMarker
public class GetBackupPlansPlainArgsBuilder internal constructor() {
    private var backupPlanName: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    /**
     * @param value The name of the resource.
     */
    @JvmName("kwsgxguxpdjmxoxo")
    public suspend fun backupPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.backupPlanName = mapped
    }

    /**
     * @param value Default to `true`. Set it to `false` can hide the `payment_type` to output.
     */
    @JvmName("vbrwnlfxtjxxplam")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Backup Plan IDs.
     */
    @JvmName("dlxakjbpopufkcwq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Backup Plan IDs.
     */
    @JvmName("yeebdtolevxsmdjw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Backup Plan name.
     */
    @JvmName("xifosfumtroglorj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xvpygcplwxmojmax")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("btnijfefvsstptdv")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("vemrnhnheqypibhx")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `check_pass`, `init`, `locked`, `pause`, `running`, `stop`, `wait`.
     */
    @JvmName("pwlshuisxqlvqpsp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBackupPlansPlainArgs = GetBackupPlansPlainArgs(
        backupPlanName = backupPlanName,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
    )
}
