@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dbs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property backupGatewayId The ID of the backup gateway.
 * @property backupMethod The Backup method.
 * @property backupObjects The backup object.
 * @property backupPeriod Full backup cycle.
 * @property backupPlanId The first ID of the resource.
 * @property backupPlanName The name of the resource.
 * @property backupRetentionPeriod The retention time of backup data.
 * @property backupStartTime The start time of full Backup.
 * @property backupStorageType Built-in storage type.
 * @property crossAliyunId The UID that is backed up across Alibaba cloud accounts.
 * @property crossRoleName The name of the RAM role that is backed up across Alibaba cloud accounts.
 * @property databaseType The database type.
 * @property duplicationArchivePeriod The storage time for conversion to archive cold standby is 365 days by default.
 * @property duplicationInfrequentAccessPeriod The storage time is converted to low-frequency access. The default time is 180 days.
 * @property enableBackupLog Whether to enable incremental log Backup.
 * @property id The ID of the Backup Plan.
 * @property instanceClass The Instance class.
 * @property ossBucketName The OSS Bucket name.
 * @property paymentType The payment type of the resource.
 * @property resourceGroupId The ID of the resource group.
 * @property sourceEndpointDatabaseName The name of the database.
 * @property sourceEndpointInstanceId The ID of the database instance.
 * @property sourceEndpointInstanceType The location of the database.
 * @property sourceEndpointRegion The region of the database.
 * @property sourceEndpointSid The Oracle SID name.
 * @property sourceEndpointUserName The source endpoint username.
 * @property status The status of the resource.
 */
public data class GetBackupPlansPlan(
    public val backupGatewayId: String,
    public val backupMethod: String,
    public val backupObjects: String,
    public val backupPeriod: String,
    public val backupPlanId: String,
    public val backupPlanName: String,
    public val backupRetentionPeriod: Int,
    public val backupStartTime: String,
    public val backupStorageType: String,
    public val crossAliyunId: String,
    public val crossRoleName: String,
    public val databaseType: String,
    public val duplicationArchivePeriod: Int,
    public val duplicationInfrequentAccessPeriod: Int,
    public val enableBackupLog: Boolean,
    public val id: String,
    public val instanceClass: String,
    public val ossBucketName: String,
    public val paymentType: String,
    public val resourceGroupId: String,
    public val sourceEndpointDatabaseName: String,
    public val sourceEndpointInstanceId: String,
    public val sourceEndpointInstanceType: String,
    public val sourceEndpointRegion: String,
    public val sourceEndpointSid: String,
    public val sourceEndpointUserName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dbs.outputs.GetBackupPlansPlan): GetBackupPlansPlan = GetBackupPlansPlan(
            backupGatewayId = javaType.backupGatewayId(),
            backupMethod = javaType.backupMethod(),
            backupObjects = javaType.backupObjects(),
            backupPeriod = javaType.backupPeriod(),
            backupPlanId = javaType.backupPlanId(),
            backupPlanName = javaType.backupPlanName(),
            backupRetentionPeriod = javaType.backupRetentionPeriod(),
            backupStartTime = javaType.backupStartTime(),
            backupStorageType = javaType.backupStorageType(),
            crossAliyunId = javaType.crossAliyunId(),
            crossRoleName = javaType.crossRoleName(),
            databaseType = javaType.databaseType(),
            duplicationArchivePeriod = javaType.duplicationArchivePeriod(),
            duplicationInfrequentAccessPeriod = javaType.duplicationInfrequentAccessPeriod(),
            enableBackupLog = javaType.enableBackupLog(),
            id = javaType.id(),
            instanceClass = javaType.instanceClass(),
            ossBucketName = javaType.ossBucketName(),
            paymentType = javaType.paymentType(),
            resourceGroupId = javaType.resourceGroupId(),
            sourceEndpointDatabaseName = javaType.sourceEndpointDatabaseName(),
            sourceEndpointInstanceId = javaType.sourceEndpointInstanceId(),
            sourceEndpointInstanceType = javaType.sourceEndpointInstanceType(),
            sourceEndpointRegion = javaType.sourceEndpointRegion(),
            sourceEndpointSid = javaType.sourceEndpointSid(),
            sourceEndpointUserName = javaType.sourceEndpointUserName(),
            status = javaType.status(),
        )
    }
}
