@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.DcdnFunctions.getDomainsPlain
import com.pulumi.alicloud.dcdn.DcdnFunctions.getIpaDomainsPlain
import com.pulumi.alicloud.dcdn.DcdnFunctions.getKvAccountPlain
import com.pulumi.alicloud.dcdn.DcdnFunctions.getServicePlain
import com.pulumi.alicloud.dcdn.DcdnFunctions.getWafDomainsPlain
import com.pulumi.alicloud.dcdn.DcdnFunctions.getWafPoliciesPlain
import com.pulumi.alicloud.dcdn.DcdnFunctions.getWafRulesPlain
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetDomainsPlainArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetDomainsPlainArgsBuilder
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetIpaDomainsPlainArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetIpaDomainsPlainArgsBuilder
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetKvAccountPlainArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetKvAccountPlainArgsBuilder
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetWafDomainsPlainArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetWafDomainsPlainArgsBuilder
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetWafPoliciesPlainArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetWafPoliciesPlainArgsBuilder
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetWafRulesPlainArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.GetWafRulesPlainArgsBuilder
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetDomainsResult
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetIpaDomainsResult
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetKvAccountResult
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafDomainsResult
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafPoliciesResult
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafRulesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetDomainsResult.Companion.toKotlin as getDomainsResultToKotlin
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetIpaDomainsResult.Companion.toKotlin as getIpaDomainsResultToKotlin
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetKvAccountResult.Companion.toKotlin as getKvAccountResultToKotlin
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafDomainsResult.Companion.toKotlin as getWafDomainsResultToKotlin
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafPoliciesResult.Companion.toKotlin as getWafPoliciesResultToKotlin
import com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafRulesResult.Companion.toKotlin as getWafRulesResultToKotlin

public object DcdnFunctions {
    /**
     * Provides a collection of DCDN Domains to the specified filters.
     * > **NOTE:** Available in 1.94.0+.
     * ## Example Usage
     *  <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.dcdn.getDomains({
     *     ids: ["example&#46;com"],
     * });
     * export const domainId = example.then(example => example.domains?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.dcdn.get_domains(ids=["example&#46;com"])
     * pulumi.export("domainId", example.domains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Dcdn.GetDomains.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example.com",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["domainId"] = example&#46;Apply(getDomainsResult => getDomainsResult&#46;Domains[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := dcdn.GetDomains(ctx, &dcdn.GetDomainsArgs{
     * 			Ids: []string{
     * 				"example.com",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("domainId", example.Domains[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dcdn.DcdnFunctions;
     * import com.pulumi.alicloud.dcdn.inputs.GetDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DcdnFunctions.getDomains(GetDomainsArgs.builder()
     *             .ids("example.com")
     *             .build());
     *         ctx.export("domainId", example.applyValue(getDomainsResult -> getDomainsResult.domains()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:dcdn:getDomains
     *       Arguments:
     *         ids:
     *           - example.com
     * outputs:
     *   domainId: ${example.domains[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomains.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: GetDomainsPlainArgs): GetDomainsResult =
        getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())

    /**
     * @see [getDomains].
     * @param changeEndTime The end time of the update. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
     * @param changeStartTime The start time of the update. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
     * @param checkDomainShow Specifies whether to display the domains in the checking, check_failed, or configure_failed status. Valid values: `true` or `false`.
     * @param domainSearchType The search method. Default value: `fuzzy_match`. Valid values: `fuzzy_match`, `pre_match`, `suf_match`, `full_match`.
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param ids A list ids of DCDN Domain.
     * @param nameRegex A regex string to filter results by the DCDN Domain.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param securityToken
     * @param status The status of DCDN Domain.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(
        changeEndTime: String? = null,
        changeStartTime: String? = null,
        checkDomainShow: Boolean? = null,
        domainSearchType: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        securityToken: String? = null,
        status: String? = null,
    ): GetDomainsResult {
        val argument = GetDomainsPlainArgs(
            changeEndTime = changeEndTime,
            changeStartTime = changeStartTime,
            checkDomainShow = checkDomainShow,
            domainSearchType = domainSearchType,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            securityToken = securityToken,
            status = status,
        )
        return getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dcdn&#46;kotlin&#46;inputs&#46;GetDomainsPlainArgs].
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: suspend GetDomainsPlainArgsBuilder.() -> Unit): GetDomainsResult {
        val builder = GetDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainsResultToKotlin(getDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dcdn Ipa Domains of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.158.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dcdn.getIpaDomains({
     *     domainName: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const dcdnIpaDomainId1 = ids.then(ids => ids.domains?.[0]?.id);
     * const status = alicloud.dcdn.getIpaDomains({
     *     status: "online",
     * });
     * export const dcdnIpaDomainId2 = status.then(status => status.domains?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dcdn.get_ipa_domains(domain_name="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("dcdnIpaDomainId1", ids.domains[0].id)
     * status = alicloud.dcdn.get_ipa_domains(status="online")
     * pulumi.export("dcdnIpaDomainId2", status.domains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dcdn.GetIpaDomains.Invoke(new()
     *     {
     *         DomainName = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var status = AliCloud.Dcdn.GetIpaDomains.Invoke(new()
     *     {
     *         Status = "online",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dcdnIpaDomainId1"] = ids&#46;Apply(getIpaDomainsResult => getIpaDomainsResult&#46;Domains[0]?.Id),
     *         ["dcdnIpaDomainId2"] = status&#46;Apply(getIpaDomainsResult => getIpaDomainsResult&#46;Domains[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dcdn.GetIpaDomains(ctx, &dcdn.GetIpaDomainsArgs{
     * 			DomainName: pulumi.StringRef("example_value"),
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dcdnIpaDomainId1", ids.Domains[0].Id)
     * 		status, err := dcdn.GetIpaDomains(ctx, &dcdn.GetIpaDomainsArgs{
     * 			Status: pulumi.StringRef("online"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dcdnIpaDomainId2", status.Domains[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dcdn.DcdnFunctions;
     * import com.pulumi.alicloud.dcdn.inputs.GetIpaDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DcdnFunctions.getIpaDomains(GetIpaDomainsArgs.builder()
     *             .domainName("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("dcdnIpaDomainId1", ids.applyValue(getIpaDomainsResult -> getIpaDomainsResult.domains()[0].id()));
     *         final var status = DcdnFunctions.getIpaDomains(GetIpaDomainsArgs.builder()
     *             .status("online")
     *             .build());
     *         ctx.export("dcdnIpaDomainId2", status.applyValue(getIpaDomainsResult -> getIpaDomainsResult.domains()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dcdn:getIpaDomains
     *       Arguments:
     *         domainName: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   status:
     *     fn::invoke:
     *       Function: alicloud:dcdn:getIpaDomains
     *       Arguments:
     *         status: online
     * outputs:
     *   dcdnIpaDomainId1: ${ids.domains[0].id}
     *   dcdnIpaDomainId2: ${status.domains[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpaDomains.
     * @return A collection of values returned by getIpaDomains.
     */
    public suspend fun getIpaDomains(argument: GetIpaDomainsPlainArgs): GetIpaDomainsResult =
        getIpaDomainsResultToKotlin(getIpaDomainsPlain(argument.toJava()).await())

    /**
     * @see [getIpaDomains].
     * @param domainName The name of the Domain.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Ipa Domain IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the accelerated domain name. Valid values: `check_failed`, `checking`, `configure_failed`, `configuring`, `offline`, `online`.
     * @return A collection of values returned by getIpaDomains.
     */
    public suspend fun getIpaDomains(
        domainName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetIpaDomainsResult {
        val argument = GetIpaDomainsPlainArgs(
            domainName = domainName,
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getIpaDomainsResultToKotlin(getIpaDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpaDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dcdn&#46;kotlin&#46;inputs&#46;GetIpaDomainsPlainArgs].
     * @return A collection of values returned by getIpaDomains.
     */
    public suspend fun getIpaDomains(argument: suspend GetIpaDomainsPlainArgsBuilder.() -> Unit): GetIpaDomainsResult {
        val builder = GetIpaDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpaDomainsResultToKotlin(getIpaDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides DCDN kv account available to the user.[What is DCDN Kv Account](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-describedcdnkvaccount)
     * > **NOTE:** Available since v1.198.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const status = alicloud.dcdn.getKvAccount({
     *     status: "online",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * status = alicloud.dcdn.get_kv_account(status="online")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var status = AliCloud.Dcdn.GetKvAccount.Invoke(new()
     *     {
     *         Status = "online",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := dcdn.GetKvAccount(ctx, &dcdn.GetKvAccountArgs{
     * 			Status: pulumi.StringRef("online"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dcdn.DcdnFunctions;
     * import com.pulumi.alicloud.dcdn.inputs.GetKvAccountArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var status = DcdnFunctions.getKvAccount(GetKvAccountArgs.builder()
     *             .status("online")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   status:
     *     fn::invoke:
     *       Function: alicloud:dcdn:getKvAccount
     *       Arguments:
     *         status: online
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKvAccount.
     * @return A collection of values returned by getKvAccount.
     */
    public suspend fun getKvAccount(argument: GetKvAccountPlainArgs): GetKvAccountResult =
        getKvAccountResultToKotlin(getKvAccountPlain(argument.toJava()).await())

    /**
     * @see [getKvAccount].
     * @param status The status of the KV feature for your account. Valid values: `online`, `offline`.
     * @return A collection of values returned by getKvAccount.
     */
    public suspend fun getKvAccount(status: String? = null): GetKvAccountResult {
        val argument = GetKvAccountPlainArgs(
            status = status,
        )
        return getKvAccountResultToKotlin(getKvAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getKvAccount].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dcdn&#46;kotlin&#46;inputs&#46;GetKvAccountPlainArgs].
     * @return A collection of values returned by getKvAccount.
     */
    public suspend fun getKvAccount(argument: suspend GetKvAccountPlainArgsBuilder.() -> Unit): GetKvAccountResult {
        val builder = GetKvAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKvAccountResultToKotlin(getKvAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open DCDN service automatically. If the service has been opened, it will return opened.
     * For information about DCDN and how to use it, see [What is DCDN](https://help.aliyun.com/document_detail/197288.html).
     * > **NOTE:** Available in v1.111.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.dcdn.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.dcdn.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Dcdn.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := dcdn.GetService(ctx, &dcdn.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dcdn.DcdnFunctions;
     * import com.pulumi.alicloud.dcdn.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = DcdnFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:dcdn:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the DCDN service that means you have read and agreed the [DCDN Terms of Service](https://help.aliyun.com/document_detail/169354.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dcdn&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dcdn Waf Domains of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.185.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dcdn.getWafDomains({});
     * export const dcdnWafDomainId1 = ids.then(ids => ids.domains?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dcdn.get_waf_domains()
     * pulumi.export("dcdnWafDomainId1", ids.domains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dcdn.GetWafDomains.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["dcdnWafDomainId1"] = ids&#46;Apply(getWafDomainsResult => getWafDomainsResult&#46;Domains[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dcdn.GetWafDomains(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dcdnWafDomainId1", ids.Domains[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dcdn.DcdnFunctions;
     * import com.pulumi.alicloud.dcdn.inputs.GetWafDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DcdnFunctions.getWafDomains();
     *         ctx.export("dcdnWafDomainId1", ids.applyValue(getWafDomainsResult -> getWafDomainsResult.domains()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dcdn:getWafDomains
     *       Arguments: {}
     * outputs:
     *   dcdnWafDomainId1: ${ids.domains[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getWafDomains.
     * @return A collection of values returned by getWafDomains.
     */
    public suspend fun getWafDomains(argument: GetWafDomainsPlainArgs): GetWafDomainsResult =
        getWafDomainsResultToKotlin(getWafDomainsPlain(argument.toJava()).await())

    /**
     * @see [getWafDomains].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Waf Domain IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param queryArgs The query conditions. You can filter domain names by name. Fuzzy match is supported `QueryArgs={"DomainName":"Accelerated domain name"}`.
     * @return A collection of values returned by getWafDomains.
     */
    public suspend fun getWafDomains(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        queryArgs: String? = null,
    ): GetWafDomainsResult {
        val argument = GetWafDomainsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            queryArgs = queryArgs,
        )
        return getWafDomainsResultToKotlin(getWafDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getWafDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dcdn&#46;kotlin&#46;inputs&#46;GetWafDomainsPlainArgs].
     * @return A collection of values returned by getWafDomains.
     */
    public suspend fun getWafDomains(argument: suspend GetWafDomainsPlainArgsBuilder.() -> Unit): GetWafDomainsResult {
        val builder = GetWafDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWafDomainsResultToKotlin(getWafDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dcdn Waf Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.184.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dcdn.getWafPolicies({});
     * export const dcdnWafPolicyId1 = ids.then(ids => ids.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dcdn.get_waf_policies()
     * pulumi.export("dcdnWafPolicyId1", ids.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dcdn.GetWafPolicies.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["dcdnWafPolicyId1"] = ids&#46;Apply(getWafPoliciesResult => getWafPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dcdn.GetWafPolicies(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dcdnWafPolicyId1", ids.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dcdn.DcdnFunctions;
     * import com.pulumi.alicloud.dcdn.inputs.GetWafPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DcdnFunctions.getWafPolicies();
     *         ctx.export("dcdnWafPolicyId1", ids.applyValue(getWafPoliciesResult -> getWafPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dcdn:getWafPolicies
     *       Arguments: {}
     * outputs:
     *   dcdnWafPolicyId1: ${ids.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getWafPolicies.
     * @return A collection of values returned by getWafPolicies.
     */
    public suspend fun getWafPolicies(argument: GetWafPoliciesPlainArgs): GetWafPoliciesResult =
        getWafPoliciesResultToKotlin(getWafPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getWafPolicies].
     * @param ids A list of Waf Policy IDs.
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param queryArgs The query conditions. The value is a string in the JSON format. Format: `{"PolicyIds":"The ID of the proteuleIds":"Thection policy","R range of protection rule IDs","PolicyNameLike":"The name of the protection policy","DomainNames":"The protected domain names","PolicyType":"default","DefenseScenes":"waf_group","PolicyStatus":"on","OrderBy":"GmtModified","Desc":"false"}`.
     * @param status The status of the resource. Valid values: `on`, `off`.
     * @return A collection of values returned by getWafPolicies.
     */
    public suspend fun getWafPolicies(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        queryArgs: String? = null,
        status: String? = null,
    ): GetWafPoliciesResult {
        val argument = GetWafPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            queryArgs = queryArgs,
            status = status,
        )
        return getWafPoliciesResultToKotlin(getWafPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getWafPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dcdn&#46;kotlin&#46;inputs&#46;GetWafPoliciesPlainArgs].
     * @return A collection of values returned by getWafPolicies.
     */
    public suspend fun getWafPolicies(argument: suspend GetWafPoliciesPlainArgsBuilder.() -> Unit): GetWafPoliciesResult {
        val builder = GetWafPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWafPoliciesResultToKotlin(getWafPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Dcdn Waf Rule available to the user.[What is Waf Rule](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-batchcreatedcdnwafrules)
     * > **NOTE:** Available since v1.201.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.dcdn.getWafRules({
     *     ids: [defaultAlicloudDcdnWafRule&#46;id],
     * });
     * export const alicloudDcdnWafRuleExampleId = _default.then(_default => _default.wafRules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.dcdn.get_waf_rules(ids=[default_alicloud_dcdn_waf_rule["id"]])
     * pulumi.export("alicloudDcdnWafRuleExampleId", default.waf_rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Dcdn.GetWafRules.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudDcdnWafRule.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudDcdnWafRuleExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getWafRulesResult => getWafRulesResult&#46;WafRules[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := dcdn.GetWafRules(ctx, &dcdn.GetWafRulesArgs{
     * Ids: interface{}{
     * defaultAlicloudDcdnWafRule.Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudDcdnWafRuleExampleId", _default.WafRules[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dcdn.DcdnFunctions;
     * import com.pulumi.alicloud.dcdn.inputs.GetWafRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = DcdnFunctions.getWafRules(GetWafRulesArgs.builder()
     *             .ids(defaultAlicloudDcdnWafRule.id())
     *             .build());
     *         ctx.export("alicloudDcdnWafRuleExampleId", default_.wafRules()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:dcdn:getWafRules
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudDcdnWafRule.id}
     * outputs:
     *   alicloudDcdnWafRuleExampleId: ${default.wafRules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getWafRules.
     * @return A collection of values returned by getWafRules.
     */
    public suspend fun getWafRules(argument: GetWafRulesPlainArgs): GetWafRulesResult =
        getWafRulesResultToKotlin(getWafRulesPlain(argument.toJava()).await())

    /**
     * @see [getWafRules].
     * @param ids A list of Waf Rule IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param queryArgs The query conditions. The value is a string in the JSON format.
     * @return A collection of values returned by getWafRules.
     */
    public suspend fun getWafRules(
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        queryArgs: String? = null,
    ): GetWafRulesResult {
        val argument = GetWafRulesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            queryArgs = queryArgs,
        )
        return getWafRulesResultToKotlin(getWafRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getWafRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dcdn&#46;kotlin&#46;inputs&#46;GetWafRulesPlainArgs].
     * @return A collection of values returned by getWafRules.
     */
    public suspend fun getWafRules(argument: suspend GetWafRulesPlainArgsBuilder.() -> Unit): GetWafRulesResult {
        val builder = GetWafRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWafRulesResultToKotlin(getWafRulesPlain(builtArgument.toJava()).await())
    }
}
