@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.kotlin.outputs.DomainSource
import com.pulumi.alicloud.dcdn.kotlin.outputs.DomainSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.alicloud.dcdn.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides a DCDN Domain resource.
 * Full station accelerated domain name.
 * For information about DCDN Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/doc-detail/130628.htm).
 * > **NOTE:** Available since v1.94.0.
 * > **NOTE:** Field `force_set`, `security_token` has been removed from provider version 1.227.1.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const domainName = config.get("domainName") || "tf-example.com";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.dcdn.Domain("example", {
 *     domainName: `${domainName}-${_default.result}`,
 *     scope: "overseas",
 *     sources: [{
 *         content: "1.1.1.1",
 *         port: 80,
 *         priority: "20",
 *         type: "ipaddr",
 *         weight: "10",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * domain_name = config.get("domainName")
 * if domain_name is None:
 *     domain_name = "tf-example.com"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.dcdn.Domain("example",
 *     domain_name=f"{domain_name}-{default['result']}",
 *     scope="overseas",
 *     sources=[{
 *         "content": "1.1.1.1",
 *         "port": 80,
 *         "priority": "20",
 *         "type": "ipaddr",
 *         "weight": "10",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var domainName = config.Get("domainName") ?? "tf-example.com";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.Dcdn.Domain("example", new()
 *     {
 *         DomainName = $"{domainName}-{@default.Result}",
 *         Scope = "overseas",
 *         Sources = new[]
 *         {
 *             new AliCloud.Dcdn.Inputs.DomainSourceArgs
 *             {
 *                 Content = "1.1.1.1",
 *                 Port = 80,
 *                 Priority = "20",
 *                 Type = "ipaddr",
 *                 Weight = "10",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		domainName := "tf-example.com"
 * 		if param := cfg.Get("domainName"); param != "" {
 * 			domainName = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewDomain(ctx, "example", &dcdn.DomainArgs{
 * 			DomainName: pulumi.Sprintf("%v-%v", domainName, _default.Result),
 * 			Scope:      pulumi.String("overseas"),
 * 			Sources: dcdn.DomainSourceArray{
 * 				&dcdn.DomainSourceArgs{
 * 					Content:  pulumi.String("1.1.1.1"),
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.String("20"),
 * 					Type:     pulumi.String("ipaddr"),
 * 					Weight:   pulumi.String("10"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dcdn.Domain;
 * import com.pulumi.alicloud.dcdn.DomainArgs;
 * import com.pulumi.alicloud.dcdn.inputs.DomainSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var domainName = config.get("domainName").orElse("tf-example.com");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName(String.format("%s-%s", domainName,default_.result()))
 *             .scope("overseas")
 *             .sources(DomainSourceArgs.builder()
 *                 .content("1.1.1.1")
 *                 .port("80")
 *                 .priority("20")
 *                 .type("ipaddr")
 *                 .weight("10")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   domainName:
 *     type: string
 *     default: tf-example.com
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:dcdn:Domain
 *     properties:
 *       domainName: ${domainName}-${default.result}
 *       scope: overseas
 *       sources:
 *         - content: 1.1.1.1
 *           port: '80'
 *           priority: '20'
 *           type: ipaddr
 *           weight: '10'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DCDN Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/domain:Domain example <id>
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.alicloud.dcdn.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
     */
    public val certId: Output<String>
        get() = javaResource.certId().applyValue({ args0 -> args0 })

    /**
     * The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
     */
    public val certName: Output<String>
        get() = javaResource.certName().applyValue({ args0 -> args0 })

    /**
     * The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
     */
    public val certRegion: Output<String>
        get() = javaResource.certRegion().applyValue({ args0 -> args0 })

    /**
     * The certificate type.
     */
    public val certType: Output<String>
        get() = javaResource.certType().applyValue({ args0 -> args0 })

    /**
     * The URL that is used for health checks.
     */
    public val checkUrl: Output<String>?
        get() = javaResource.checkUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The CNAME domain name corresponding to the accelerated domain name.
     */
    public val cname: Output<String>
        get() = javaResource.cname().applyValue({ args0 -> args0 })

    /**
     * The time when the accelerated domain name was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
     */
    public val env: Output<String>?
        get() = javaResource.env().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Computing service type. Valid values:
     */
    public val functionType: Output<String>?
        get() = javaResource.functionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The Acceleration scen. Supported:
     */
    public val scene: Output<String>?
        get() = javaResource.scene().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The region where the acceleration service is deployed. Valid values:
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Source  See `sources` below.
     */
    public val sources: Output<List<DomainSource>>?
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The private key. Specify the private key only if you want to enable the SSL certificate.
     */
    public val sslPri: Output<String>?
        get() = javaResource.sslPri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to enable the SSL certificate. Valid values:
     */
    public val sslProtocol: Output<String>?
        get() = javaResource.sslProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
     */
    public val sslPub: Output<String>
        get() = javaResource.sslPub().applyValue({ args0 -> args0 })

    /**
     * The status of the domain name. Valid values:
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The top-level domain.
     */
    public val topLevelDomain: Output<String>?
        get() = javaResource.topLevelDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dcdn.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.alicloud.dcdn.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
