@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.DomainArgs.builder
import com.pulumi.alicloud.dcdn.kotlin.inputs.DomainSourceArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.DomainSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DCDN Domain resource.
 * Full station accelerated domain name.
 * For information about DCDN Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/doc-detail/130628.htm).
 * > **NOTE:** Available since v1.94.0.
 * > **NOTE:** Field `force_set`, `security_token` has been removed from provider version 1.227.1.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const domainName = config.get("domainName") || "tf-example.com";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.dcdn.Domain("example", {
 *     domainName: `${domainName}-${_default.result}`,
 *     scope: "overseas",
 *     sources: [{
 *         content: "1.1.1.1",
 *         port: 80,
 *         priority: "20",
 *         type: "ipaddr",
 *         weight: "10",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * domain_name = config.get("domainName")
 * if domain_name is None:
 *     domain_name = "tf-example.com"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.dcdn.Domain("example",
 *     domain_name=f"{domain_name}-{default['result']}",
 *     scope="overseas",
 *     sources=[{
 *         "content": "1.1.1.1",
 *         "port": 80,
 *         "priority": "20",
 *         "type": "ipaddr",
 *         "weight": "10",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var domainName = config.Get("domainName") ?? "tf-example.com";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.Dcdn.Domain("example", new()
 *     {
 *         DomainName = $"{domainName}-{@default.Result}",
 *         Scope = "overseas",
 *         Sources = new[]
 *         {
 *             new AliCloud.Dcdn.Inputs.DomainSourceArgs
 *             {
 *                 Content = "1.1.1.1",
 *                 Port = 80,
 *                 Priority = "20",
 *                 Type = "ipaddr",
 *                 Weight = "10",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		domainName := "tf-example.com"
 * 		if param := cfg.Get("domainName"); param != "" {
 * 			domainName = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewDomain(ctx, "example", &dcdn.DomainArgs{
 * 			DomainName: pulumi.Sprintf("%v-%v", domainName, _default.Result),
 * 			Scope:      pulumi.String("overseas"),
 * 			Sources: dcdn.DomainSourceArray{
 * 				&dcdn.DomainSourceArgs{
 * 					Content:  pulumi.String("1.1.1.1"),
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.String("20"),
 * 					Type:     pulumi.String("ipaddr"),
 * 					Weight:   pulumi.String("10"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dcdn.Domain;
 * import com.pulumi.alicloud.dcdn.DomainArgs;
 * import com.pulumi.alicloud.dcdn.inputs.DomainSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var domainName = config.get("domainName").orElse("tf-example.com");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName(String.format("%s-%s", domainName,default_.result()))
 *             .scope("overseas")
 *             .sources(DomainSourceArgs.builder()
 *                 .content("1.1.1.1")
 *                 .port("80")
 *                 .priority("20")
 *                 .type("ipaddr")
 *                 .weight("10")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   domainName:
 *     type: string
 *     default: tf-example.com
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:dcdn:Domain
 *     properties:
 *       domainName: ${domainName}-${default.result}
 *       scope: overseas
 *       sources:
 *         - content: 1.1.1.1
 *           port: '80'
 *           priority: '20'
 *           type: ipaddr
 *           weight: '10'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DCDN Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/domain:Domain example <id>
 * ```
 * @property certId The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
 * @property certName The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
 * @property certRegion The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
 * @property certType The certificate type.
 * @property checkUrl The URL that is used for health checks.
 * @property domainName The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
 * @property env Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
 * @property functionType Computing service type. Valid values:
 * @property resourceGroupId The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
 * @property scene The Acceleration scen. Supported:
 * @property scope The region where the acceleration service is deployed. Valid values:
 * @property sources Source  See `sources` below.
 * @property sslPri The private key. Specify the private key only if you want to enable the SSL certificate.
 * @property sslProtocol Specifies whether to enable the SSL certificate. Valid values:
 * @property sslPub The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
 * @property status The status of the domain name. Valid values:
 * @property tags The tag of the resource
 * @property topLevelDomain The top-level domain.
 */
public data class DomainArgs(
    public val certId: Output<String>? = null,
    public val certName: Output<String>? = null,
    public val certRegion: Output<String>? = null,
    public val certType: Output<String>? = null,
    public val checkUrl: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val env: Output<String>? = null,
    public val functionType: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scene: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sources: Output<List<DomainSourceArgs>>? = null,
    public val sslPri: Output<String>? = null,
    public val sslProtocol: Output<String>? = null,
    public val sslPub: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topLevelDomain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.DomainArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.DomainArgs =
        com.pulumi.alicloud.dcdn.DomainArgs.builder()
            .certId(certId?.applyValue({ args0 -> args0 }))
            .certName(certName?.applyValue({ args0 -> args0 }))
            .certRegion(certRegion?.applyValue({ args0 -> args0 }))
            .certType(certType?.applyValue({ args0 -> args0 }))
            .checkUrl(checkUrl?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .env(env?.applyValue({ args0 -> args0 }))
            .functionType(functionType?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scene(scene?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sslPri(sslPri?.applyValue({ args0 -> args0 }))
            .sslProtocol(sslProtocol?.applyValue({ args0 -> args0 }))
            .sslPub(sslPub?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topLevelDomain(topLevelDomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var certId: Output<String>? = null

    private var certName: Output<String>? = null

    private var certRegion: Output<String>? = null

    private var certType: Output<String>? = null

    private var checkUrl: Output<String>? = null

    private var domainName: Output<String>? = null

    private var env: Output<String>? = null

    private var functionType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var scene: Output<String>? = null

    private var scope: Output<String>? = null

    private var sources: Output<List<DomainSourceArgs>>? = null

    private var sslPri: Output<String>? = null

    private var sslProtocol: Output<String>? = null

    private var sslPub: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topLevelDomain: Output<String>? = null

    /**
     * @param value The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
     */
    @JvmName("fplojyijentjcoum")
    public suspend fun certId(`value`: Output<String>) {
        this.certId = value
    }

    /**
     * @param value The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
     */
    @JvmName("giqlgvfjyoxtgeoq")
    public suspend fun certName(`value`: Output<String>) {
        this.certName = value
    }

    /**
     * @param value The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
     */
    @JvmName("inwwmeibwmivjfne")
    public suspend fun certRegion(`value`: Output<String>) {
        this.certRegion = value
    }

    /**
     * @param value The certificate type.
     */
    @JvmName("qvtiomvboqxrpejq")
    public suspend fun certType(`value`: Output<String>) {
        this.certType = value
    }

    /**
     * @param value The URL that is used for health checks.
     */
    @JvmName("piykfilnuedkibvl")
    public suspend fun checkUrl(`value`: Output<String>) {
        this.checkUrl = value
    }

    /**
     * @param value The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
     */
    @JvmName("fglejwkmdvpjkxcm")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
     */
    @JvmName("ralsvwovnpswbhes")
    public suspend fun env(`value`: Output<String>) {
        this.env = value
    }

    /**
     * @param value Computing service type. Valid values:
     */
    @JvmName("vbfjdubuhwfaynuf")
    public suspend fun functionType(`value`: Output<String>) {
        this.functionType = value
    }

    /**
     * @param value The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
     */
    @JvmName("wgnxtsmnrkwirxsj")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The Acceleration scen. Supported:
     */
    @JvmName("eiotwoovdehetewg")
    public suspend fun scene(`value`: Output<String>) {
        this.scene = value
    }

    /**
     * @param value The region where the acceleration service is deployed. Valid values:
     */
    @JvmName("kwjatnpgdfjdxwha")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Source  See `sources` below.
     */
    @JvmName("vdctdjlpctgvoufr")
    public suspend fun sources(`value`: Output<List<DomainSourceArgs>>) {
        this.sources = value
    }

    @JvmName("aqxuwqfdcfnrbixa")
    public suspend fun sources(vararg values: Output<DomainSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values Source  See `sources` below.
     */
    @JvmName("yvnbbwesqcxkpbkp")
    public suspend fun sources(values: List<Output<DomainSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The private key. Specify the private key only if you want to enable the SSL certificate.
     */
    @JvmName("ijieavwspmhuytbk")
    public suspend fun sslPri(`value`: Output<String>) {
        this.sslPri = value
    }

    /**
     * @param value Specifies whether to enable the SSL certificate. Valid values:
     */
    @JvmName("lfeiavmtordavkbr")
    public suspend fun sslProtocol(`value`: Output<String>) {
        this.sslProtocol = value
    }

    /**
     * @param value The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
     */
    @JvmName("fyanaxurekdixsbu")
    public suspend fun sslPub(`value`: Output<String>) {
        this.sslPub = value
    }

    /**
     * @param value The status of the domain name. Valid values:
     */
    @JvmName("hejqpomqridgjapv")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("ybxmbngxflwbfskt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The top-level domain.
     */
    @JvmName("jrgrambubugcvldp")
    public suspend fun topLevelDomain(`value`: Output<String>) {
        this.topLevelDomain = value
    }

    /**
     * @param value The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
     */
    @JvmName("muixbftoivbdadhg")
    public suspend fun certId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certId = mapped
    }

    /**
     * @param value The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
     */
    @JvmName("ubqafqipbmiertvg")
    public suspend fun certName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certName = mapped
    }

    /**
     * @param value The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
     */
    @JvmName("dnllykdqhaaijabk")
    public suspend fun certRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certRegion = mapped
    }

    /**
     * @param value The certificate type.
     */
    @JvmName("esdrdbmosqtgakwu")
    public suspend fun certType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certType = mapped
    }

    /**
     * @param value The URL that is used for health checks.
     */
    @JvmName("pgamduywndxffgcl")
    public suspend fun checkUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkUrl = mapped
    }

    /**
     * @param value The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
     */
    @JvmName("rhvtpcobmqaaohhc")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
     */
    @JvmName("oexxmourfephsfew")
    public suspend fun env(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param value Computing service type. Valid values:
     */
    @JvmName("xjvcvgnxwjpvvshh")
    public suspend fun functionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionType = mapped
    }

    /**
     * @param value The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
     */
    @JvmName("cbbxaiqanxrbpoxv")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The Acceleration scen. Supported:
     */
    @JvmName("gmpvphbcuwmrpoko")
    public suspend fun scene(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scene = mapped
    }

    /**
     * @param value The region where the acceleration service is deployed. Valid values:
     */
    @JvmName("mnytiyhxthlxceuv")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Source  See `sources` below.
     */
    @JvmName("fmuagnsueyhergam")
    public suspend fun sources(`value`: List<DomainSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument Source  See `sources` below.
     */
    @JvmName("tfnbdwevrudcvrpk")
    public suspend fun sources(argument: List<suspend DomainSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Source  See `sources` below.
     */
    @JvmName("globcpucmndodtpa")
    public suspend fun sources(vararg argument: suspend DomainSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Source  See `sources` below.
     */
    @JvmName("clhkwwhgbhpvypxp")
    public suspend fun sources(argument: suspend DomainSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values Source  See `sources` below.
     */
    @JvmName("wodwhdehctpwwkul")
    public suspend fun sources(vararg values: DomainSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value The private key. Specify the private key only if you want to enable the SSL certificate.
     */
    @JvmName("xatijhpyqdgqjtpu")
    public suspend fun sslPri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPri = mapped
    }

    /**
     * @param value Specifies whether to enable the SSL certificate. Valid values:
     */
    @JvmName("seqxaxgxbdryfbqb")
    public suspend fun sslProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslProtocol = mapped
    }

    /**
     * @param value The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
     */
    @JvmName("qulasndyfwerancs")
    public suspend fun sslPub(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPub = mapped
    }

    /**
     * @param value The status of the domain name. Valid values:
     */
    @JvmName("ceclpexxpjutmsaq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("fhowrvtemyxjkiaj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource
     */
    @JvmName("mlvnirdkkmnohdmo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The top-level domain.
     */
    @JvmName("xpjfixiefhgawhig")
    public suspend fun topLevelDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topLevelDomain = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        certId = certId,
        certName = certName,
        certRegion = certRegion,
        certType = certType,
        checkUrl = checkUrl,
        domainName = domainName,
        env = env,
        functionType = functionType,
        resourceGroupId = resourceGroupId,
        scene = scene,
        scope = scope,
        sources = sources,
        sslPri = sslPri,
        sslProtocol = sslProtocol,
        sslPub = sslPub,
        status = status,
        tags = tags,
        topLevelDomain = topLevelDomain,
    )
}
