@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.kotlin.outputs.ErEnvConf
import com.pulumi.alicloud.dcdn.kotlin.outputs.ErEnvConf.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Er].
 */
@PulumiTagMarker
public class ErResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ErArgs = ErArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ErArgsBuilder.() -> Unit) {
        val builder = ErArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Er {
        val builtJavaResource = com.pulumi.alicloud.dcdn.Er(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Er(builtJavaResource)
    }
}

/**
 * Provides a DCDN Er resource.
 * For information about DCDN Er and how to use it, see [What is Er](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-createroutine).
 * > **NOTE:** Available since v1.201.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.dcdn.Er("default", {
 *     erName: name,
 *     description: name,
 *     envConf: {
 *         staging: {
 *             specName: "5ms",
 *             allowedHosts: ["example&#46;com"],
 *         },
 *         production: {
 *             specName: "5ms",
 *             allowedHosts: ["example&#46;com"],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.dcdn.Er("default",
 *     er_name=name,
 *     description=name,
 *     env_conf={
 *         "staging": {
 *             "spec_name": "5ms",
 *             "allowed_hosts": ["example&#46;com"],
 *         },
 *         "production": {
 *             "spec_name": "5ms",
 *             "allowed_hosts": ["example&#46;com"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Dcdn.Er("default", new()
 *     {
 *         ErName = name,
 *         Description = name,
 *         EnvConf = new AliCloud.Dcdn.Inputs.ErEnvConfArgs
 *         {
 *             Staging = new AliCloud.Dcdn.Inputs.ErEnvConfStagingArgs
 *             {
 *                 SpecName = "5ms",
 *                 AllowedHosts = new[]
 *                 {
 *                     "example.com",
 *                 },
 *             },
 *             Production = new AliCloud.Dcdn.Inputs.ErEnvConfProductionArgs
 *             {
 *                 SpecName = "5ms",
 *                 AllowedHosts = new[]
 *                 {
 *                     "example.com",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := dcdn.NewEr(ctx, "default", &dcdn.ErArgs{
 * 			ErName:      pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			EnvConf: &dcdn.ErEnvConfArgs{
 * 				Staging: &dcdn.ErEnvConfStagingArgs{
 * 					SpecName: pulumi.String("5ms"),
 * 					AllowedHosts: pulumi.StringArray{
 * 						pulumi.String("example.com"),
 * 					},
 * 				},
 * 				Production: &dcdn.ErEnvConfProductionArgs{
 * 					SpecName: pulumi.String("5ms"),
 * 					AllowedHosts: pulumi.StringArray{
 * 						pulumi.String("example.com"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dcdn.Er;
 * import com.pulumi.alicloud.dcdn.ErArgs;
 * import com.pulumi.alicloud.dcdn.inputs.ErEnvConfArgs;
 * import com.pulumi.alicloud.dcdn.inputs.ErEnvConfStagingArgs;
 * import com.pulumi.alicloud.dcdn.inputs.ErEnvConfProductionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Er("default", ErArgs.builder()
 *             .erName(name)
 *             .description(name)
 *             .envConf(ErEnvConfArgs.builder()
 *                 .staging(ErEnvConfStagingArgs.builder()
 *                     .specName("5ms")
 *                     .allowedHosts("example.com")
 *                     .build())
 *                 .production(ErEnvConfProductionArgs.builder()
 *                     .specName("5ms")
 *                     .allowedHosts("example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:dcdn:Er
 *     properties:
 *       erName: ${name}
 *       description: ${name}
 *       envConf:
 *         staging:
 *           specName: 5ms
 *           allowedHosts:
 *             - example.com
 *         production:
 *           specName: 5ms
 *           allowedHosts:
 *             - example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DCDN Er can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/er:Er example <id>
 * ```
 */
public class Er internal constructor(
    override val javaResource: com.pulumi.alicloud.dcdn.Er,
) : KotlinCustomResource(javaResource, ErMapper) {
    /**
     * Routine The description of the routine.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The configurations of the specified environment. See `env_conf` below.
     */
    public val envConf: Output<ErEnvConf>
        get() = javaResource.envConf().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
     */
    public val erName: Output<String>
        get() = javaResource.erName().applyValue({ args0 -> args0 })
}

public object ErMapper : ResourceMapper<Er> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dcdn.Er::class == javaResource::class

    override fun map(javaResource: Resource): Er = Er(javaResource as com.pulumi.alicloud.dcdn.Er)
}

/**
 * @see [Er].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Er].
 */
public suspend fun er(name: String, block: suspend ErResourceBuilder.() -> Unit): Er {
    val builder = ErResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Er].
 * @param name The _unique_ name of the resulting resource.
 */
public fun er(name: String): Er {
    val builder = ErResourceBuilder()
    builder.name(name)
    return builder.build()
}
