@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.ErArgs.builder
import com.pulumi.alicloud.dcdn.kotlin.inputs.ErEnvConfArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.ErEnvConfArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a DCDN Er resource.
 * For information about DCDN Er and how to use it, see [What is Er](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-createroutine).
 * > **NOTE:** Available since v1.201.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.dcdn.Er("default", {
 *     erName: name,
 *     description: name,
 *     envConf: {
 *         staging: {
 *             specName: "5ms",
 *             allowedHosts: ["example&#46;com"],
 *         },
 *         production: {
 *             specName: "5ms",
 *             allowedHosts: ["example&#46;com"],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.dcdn.Er("default",
 *     er_name=name,
 *     description=name,
 *     env_conf={
 *         "staging": {
 *             "spec_name": "5ms",
 *             "allowed_hosts": ["example&#46;com"],
 *         },
 *         "production": {
 *             "spec_name": "5ms",
 *             "allowed_hosts": ["example&#46;com"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Dcdn.Er("default", new()
 *     {
 *         ErName = name,
 *         Description = name,
 *         EnvConf = new AliCloud.Dcdn.Inputs.ErEnvConfArgs
 *         {
 *             Staging = new AliCloud.Dcdn.Inputs.ErEnvConfStagingArgs
 *             {
 *                 SpecName = "5ms",
 *                 AllowedHosts = new[]
 *                 {
 *                     "example.com",
 *                 },
 *             },
 *             Production = new AliCloud.Dcdn.Inputs.ErEnvConfProductionArgs
 *             {
 *                 SpecName = "5ms",
 *                 AllowedHosts = new[]
 *                 {
 *                     "example.com",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := dcdn.NewEr(ctx, "default", &dcdn.ErArgs{
 * 			ErName:      pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			EnvConf: &dcdn.ErEnvConfArgs{
 * 				Staging: &dcdn.ErEnvConfStagingArgs{
 * 					SpecName: pulumi.String("5ms"),
 * 					AllowedHosts: pulumi.StringArray{
 * 						pulumi.String("example.com"),
 * 					},
 * 				},
 * 				Production: &dcdn.ErEnvConfProductionArgs{
 * 					SpecName: pulumi.String("5ms"),
 * 					AllowedHosts: pulumi.StringArray{
 * 						pulumi.String("example.com"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dcdn.Er;
 * import com.pulumi.alicloud.dcdn.ErArgs;
 * import com.pulumi.alicloud.dcdn.inputs.ErEnvConfArgs;
 * import com.pulumi.alicloud.dcdn.inputs.ErEnvConfStagingArgs;
 * import com.pulumi.alicloud.dcdn.inputs.ErEnvConfProductionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Er("default", ErArgs.builder()
 *             .erName(name)
 *             .description(name)
 *             .envConf(ErEnvConfArgs.builder()
 *                 .staging(ErEnvConfStagingArgs.builder()
 *                     .specName("5ms")
 *                     .allowedHosts("example.com")
 *                     .build())
 *                 .production(ErEnvConfProductionArgs.builder()
 *                     .specName("5ms")
 *                     .allowedHosts("example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:dcdn:Er
 *     properties:
 *       erName: ${name}
 *       description: ${name}
 *       envConf:
 *         staging:
 *           specName: 5ms
 *           allowedHosts:
 *             - example.com
 *         production:
 *           specName: 5ms
 *           allowedHosts:
 *             - example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DCDN Er can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/er:Er example <id>
 * ```
 * @property description Routine The description of the routine.
 * @property envConf The configurations of the specified environment. See `env_conf` below.
 * @property erName The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
 */
public data class ErArgs(
    public val description: Output<String>? = null,
    public val envConf: Output<ErEnvConfArgs>? = null,
    public val erName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.ErArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.ErArgs = com.pulumi.alicloud.dcdn.ErArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .envConf(envConf?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .erName(erName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ErArgs].
 */
@PulumiTagMarker
public class ErArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var envConf: Output<ErEnvConfArgs>? = null

    private var erName: Output<String>? = null

    /**
     * @param value Routine The description of the routine.
     */
    @JvmName("obtulqvlrjkppuij")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The configurations of the specified environment. See `env_conf` below.
     */
    @JvmName("ydpdknpohnimudnj")
    public suspend fun envConf(`value`: Output<ErEnvConfArgs>) {
        this.envConf = value
    }

    /**
     * @param value The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
     */
    @JvmName("hnjptleykoliwwkb")
    public suspend fun erName(`value`: Output<String>) {
        this.erName = value
    }

    /**
     * @param value Routine The description of the routine.
     */
    @JvmName("supsqbjsraeojqcs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The configurations of the specified environment. See `env_conf` below.
     */
    @JvmName("viwpeefgixrxotpn")
    public suspend fun envConf(`value`: ErEnvConfArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envConf = mapped
    }

    /**
     * @param argument The configurations of the specified environment. See `env_conf` below.
     */
    @JvmName("tgutxdhucmrehfsu")
    public suspend fun envConf(argument: suspend ErEnvConfArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.envConf = mapped
    }

    /**
     * @param value The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
     */
    @JvmName("ljttnwssigovyqoh")
    public suspend fun erName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.erName = mapped
    }

    internal fun build(): ErArgs = ErArgs(
        description = description,
        envConf = envConf,
        erName = erName,
    )
}
