@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.kotlin.outputs.IpaDomainSource
import com.pulumi.alicloud.dcdn.kotlin.outputs.IpaDomainSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [IpaDomain].
 */
@PulumiTagMarker
public class IpaDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpaDomainArgs = IpaDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpaDomainArgsBuilder.() -> Unit) {
        val builder = IpaDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IpaDomain {
        val builtJavaResource = com.pulumi.alicloud.dcdn.IpaDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IpaDomain(builtJavaResource)
    }
}

/**
 * Provides a DCDN Ipa Domain resource.
 * For information about DCDN Ipa Domain and how to use it, see [What is Ipa Domain](https://www.alibabacloud.com/help/en/doc-detail/130634.html).
 * > **NOTE:** Available since v1.158.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const example = new alicloud.dcdn.IpaDomain("example", {
 *     domainName: `example-${defaultInteger.result}.com`,
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     scope: "overseas",
 *     status: "online",
 *     sources: [{
 *         content: "www.alicloud-provider.cn",
 *         port: 8898,
 *         priority: "20",
 *         type: "domain",
 *         weight: 10,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default = alicloud.resourcemanager.get_resource_groups()
 * example = alicloud.dcdn.IpaDomain("example",
 *     domain_name=f"example-{default_integer['result']}.com",
 *     resource_group_id=default.groups[0].id,
 *     scope="overseas",
 *     status="online",
 *     sources=[{
 *         "content": "www.alicloud-provider.cn",
 *         "port": 8898,
 *         "priority": "20",
 *         "type": "domain",
 *         "weight": 10,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var example = new AliCloud.Dcdn.IpaDomain("example", new()
 *     {
 *         DomainName = $"example-{defaultInteger.Result}.com",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         Scope = "overseas",
 *         Status = "online",
 *         Sources = new[]
 *         {
 *             new AliCloud.Dcdn.Inputs.IpaDomainSourceArgs
 *             {
 *                 Content = "www.alicloud-provider.cn",
 *                 Port = 8898,
 *                 Priority = "20",
 *                 Type = "domain",
 *                 Weight = 10,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewIpaDomain(ctx, "example", &dcdn.IpaDomainArgs{
 * 			DomainName:      pulumi.Sprintf("example-%v.com", defaultInteger.Result),
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 			Scope:           pulumi.String("overseas"),
 * 			Status:          pulumi.String("online"),
 * 			Sources: dcdn.IpaDomainSourceArray{
 * 				&dcdn.IpaDomainSourceArgs{
 * 					Content:  pulumi.String("www.alicloud-provider.cn"),
 * 					Port:     pulumi.Int(8898),
 * 					Priority: pulumi.String("20"),
 * 					Type:     pulumi.String("domain"),
 * 					Weight:   pulumi.Int(10),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.dcdn.IpaDomain;
 * import com.pulumi.alicloud.dcdn.IpaDomainArgs;
 * import com.pulumi.alicloud.dcdn.inputs.IpaDomainSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var example = new IpaDomain("example", IpaDomainArgs.builder()
 *             .domainName(String.format("example-%s.com", defaultInteger.result()))
 *             .resourceGroupId(default_.groups()[0].id())
 *             .scope("overseas")
 *             .status("online")
 *             .sources(IpaDomainSourceArgs.builder()
 *                 .content("www.alicloud-provider.cn")
 *                 .port(8898)
 *                 .priority("20")
 *                 .type("domain")
 *                 .weight(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:dcdn:IpaDomain
 *     properties:
 *       domainName: example-${defaultInteger.result}.com
 *       resourceGroupId: ${default.groups[0].id}
 *       scope: overseas
 *       status: online
 *       sources:
 *         - content: www.alicloud-provider.cn
 *           port: 8898
 *           priority: '20'
 *           type: domain
 *           weight: 10
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DCDN Ipa Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/ipaDomain:IpaDomain example <domain_name>
 * ```
 */
public class IpaDomain internal constructor(
    override val javaResource: com.pulumi.alicloud.dcdn.IpaDomain,
) : KotlinCustomResource(javaResource, IpaDomainMapper) {
    /**
     * The domain name to be added to IPA. Wildcard domain names are supported. A wildcard domain name must start with a period (.).
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group. If you do not set this parameter, the system automatically assigns the ID of the default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The accelerated region. Valid values: `domestic`, `global`, `overseas`.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * Sources. See `sources` below.
     */
    public val sources: Output<List<IpaDomainSource>>
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The status of DCDN Ipa Domain. Valid values: `online`, `offline`. Default to `online`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object IpaDomainMapper : ResourceMapper<IpaDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dcdn.IpaDomain::class == javaResource::class

    override fun map(javaResource: Resource): IpaDomain = IpaDomain(
        javaResource as
            com.pulumi.alicloud.dcdn.IpaDomain,
    )
}

/**
 * @see [IpaDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpaDomain].
 */
public suspend fun ipaDomain(name: String, block: suspend IpaDomainResourceBuilder.() -> Unit): IpaDomain {
    val builder = IpaDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpaDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipaDomain(name: String): IpaDomain {
    val builder = IpaDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
