@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.IpaDomainArgs.builder
import com.pulumi.alicloud.dcdn.kotlin.inputs.IpaDomainSourceArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.IpaDomainSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DCDN Ipa Domain resource.
 * For information about DCDN Ipa Domain and how to use it, see [What is Ipa Domain](https://www.alibabacloud.com/help/en/doc-detail/130634.html).
 * > **NOTE:** Available since v1.158.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const example = new alicloud.dcdn.IpaDomain("example", {
 *     domainName: `example-${defaultInteger.result}.com`,
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     scope: "overseas",
 *     status: "online",
 *     sources: [{
 *         content: "www.alicloud-provider.cn",
 *         port: 8898,
 *         priority: "20",
 *         type: "domain",
 *         weight: 10,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default = alicloud.resourcemanager.get_resource_groups()
 * example = alicloud.dcdn.IpaDomain("example",
 *     domain_name=f"example-{default_integer['result']}.com",
 *     resource_group_id=default.groups[0].id,
 *     scope="overseas",
 *     status="online",
 *     sources=[{
 *         "content": "www.alicloud-provider.cn",
 *         "port": 8898,
 *         "priority": "20",
 *         "type": "domain",
 *         "weight": 10,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var example = new AliCloud.Dcdn.IpaDomain("example", new()
 *     {
 *         DomainName = $"example-{defaultInteger.Result}.com",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         Scope = "overseas",
 *         Status = "online",
 *         Sources = new[]
 *         {
 *             new AliCloud.Dcdn.Inputs.IpaDomainSourceArgs
 *             {
 *                 Content = "www.alicloud-provider.cn",
 *                 Port = 8898,
 *                 Priority = "20",
 *                 Type = "domain",
 *                 Weight = 10,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewIpaDomain(ctx, "example", &dcdn.IpaDomainArgs{
 * 			DomainName:      pulumi.Sprintf("example-%v.com", defaultInteger.Result),
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 			Scope:           pulumi.String("overseas"),
 * 			Status:          pulumi.String("online"),
 * 			Sources: dcdn.IpaDomainSourceArray{
 * 				&dcdn.IpaDomainSourceArgs{
 * 					Content:  pulumi.String("www.alicloud-provider.cn"),
 * 					Port:     pulumi.Int(8898),
 * 					Priority: pulumi.String("20"),
 * 					Type:     pulumi.String("domain"),
 * 					Weight:   pulumi.Int(10),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.dcdn.IpaDomain;
 * import com.pulumi.alicloud.dcdn.IpaDomainArgs;
 * import com.pulumi.alicloud.dcdn.inputs.IpaDomainSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var example = new IpaDomain("example", IpaDomainArgs.builder()
 *             .domainName(String.format("example-%s.com", defaultInteger.result()))
 *             .resourceGroupId(default_.groups()[0].id())
 *             .scope("overseas")
 *             .status("online")
 *             .sources(IpaDomainSourceArgs.builder()
 *                 .content("www.alicloud-provider.cn")
 *                 .port(8898)
 *                 .priority("20")
 *                 .type("domain")
 *                 .weight(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:dcdn:IpaDomain
 *     properties:
 *       domainName: example-${defaultInteger.result}.com
 *       resourceGroupId: ${default.groups[0].id}
 *       scope: overseas
 *       status: online
 *       sources:
 *         - content: www.alicloud-provider.cn
 *           port: 8898
 *           priority: '20'
 *           type: domain
 *           weight: 10
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DCDN Ipa Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/ipaDomain:IpaDomain example <domain_name>
 * ```
 * @property domainName The domain name to be added to IPA. Wildcard domain names are supported. A wildcard domain name must start with a period (.).
 * @property resourceGroupId The ID of the resource group. If you do not set this parameter, the system automatically assigns the ID of the default resource group.
 * @property scope The accelerated region. Valid values: `domestic`, `global`, `overseas`.
 * @property sources Sources. See `sources` below.
 * @property status The status of DCDN Ipa Domain. Valid values: `online`, `offline`. Default to `online`.
 */
public data class IpaDomainArgs(
    public val domainName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sources: Output<List<IpaDomainSourceArgs>>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.IpaDomainArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.IpaDomainArgs =
        com.pulumi.alicloud.dcdn.IpaDomainArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpaDomainArgs].
 */
@PulumiTagMarker
public class IpaDomainArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var scope: Output<String>? = null

    private var sources: Output<List<IpaDomainSourceArgs>>? = null

    private var status: Output<String>? = null

    /**
     * @param value The domain name to be added to IPA. Wildcard domain names are supported. A wildcard domain name must start with a period (.).
     */
    @JvmName("varhacxqdnkxirjc")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The ID of the resource group. If you do not set this parameter, the system automatically assigns the ID of the default resource group.
     */
    @JvmName("rgbdiquimmakrxye")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The accelerated region. Valid values: `domestic`, `global`, `overseas`.
     */
    @JvmName("tmxlprcoiyruwsdu")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Sources. See `sources` below.
     */
    @JvmName("fqicmrgtvkafibyf")
    public suspend fun sources(`value`: Output<List<IpaDomainSourceArgs>>) {
        this.sources = value
    }

    @JvmName("kplmdfnkywkuxbpv")
    public suspend fun sources(vararg values: Output<IpaDomainSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values Sources. See `sources` below.
     */
    @JvmName("phbnivkfcxicceea")
    public suspend fun sources(values: List<Output<IpaDomainSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The status of DCDN Ipa Domain. Valid values: `online`, `offline`. Default to `online`.
     */
    @JvmName("jkyngqpekkfifklr")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The domain name to be added to IPA. Wildcard domain names are supported. A wildcard domain name must start with a period (.).
     */
    @JvmName("okjsxksubnalqeje")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The ID of the resource group. If you do not set this parameter, the system automatically assigns the ID of the default resource group.
     */
    @JvmName("sehjiwrmjygcywki")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The accelerated region. Valid values: `domestic`, `global`, `overseas`.
     */
    @JvmName("uvyhoeulshmdlkng")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Sources. See `sources` below.
     */
    @JvmName("emreymaqrlqvgvgd")
    public suspend fun sources(`value`: List<IpaDomainSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument Sources. See `sources` below.
     */
    @JvmName("psdcmvktkcopjxqk")
    public suspend fun sources(argument: List<suspend IpaDomainSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpaDomainSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Sources. See `sources` below.
     */
    @JvmName("wvtfgdjmksdvcbrb")
    public suspend fun sources(vararg argument: suspend IpaDomainSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpaDomainSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Sources. See `sources` below.
     */
    @JvmName("afftrjhragclsjyg")
    public suspend fun sources(argument: suspend IpaDomainSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpaDomainSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values Sources. See `sources` below.
     */
    @JvmName("oysbqqikwceeabou")
    public suspend fun sources(vararg values: IpaDomainSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value The status of DCDN Ipa Domain. Valid values: `online`, `offline`. Default to `online`.
     */
    @JvmName("tdiwfhhdlxvmqkxi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): IpaDomainArgs = IpaDomainArgs(
        domainName = domainName,
        resourceGroupId = resourceGroupId,
        scope = scope,
        sources = sources,
        status = status,
    )
}
