@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.KvArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Dcdn Kv resource.
 * For information about Dcdn Kv and how to use it, see [What is Kv](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-putdcdnkv).
 * > **NOTE:** Available since v1.198.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultKvNamespace = new alicloud.dcdn.KvNamespace("default", {
 *     description: name,
 *     namespace: `${name}-${_default.result}`,
 * });
 * const defaultKv = new alicloud.dcdn.Kv("default", {
 *     value: "example-value",
 *     key: `${name}-${_default.result}`,
 *     namespace: defaultKvNamespace.namespace,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_kv_namespace = alicloud.dcdn.KvNamespace("default",
 *     description=name,
 *     namespace=f"{name}-{default['result']}")
 * default_kv = alicloud.dcdn.Kv("default",
 *     value="example-value",
 *     key=f"{name}-{default['result']}",
 *     namespace=default_kv_namespace.namespace)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultKvNamespace = new AliCloud.Dcdn.KvNamespace("default", new()
 *     {
 *         Description = name,
 *         Namespace = $"{name}-{@default.Result}",
 *     });
 *     var defaultKv = new AliCloud.Dcdn.Kv("default", new()
 *     {
 *         Value = "example-value",
 *         Key = $"{name}-{@default.Result}",
 *         Namespace = defaultKvNamespace.Namespace,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultKvNamespace, err := dcdn.NewKvNamespace(ctx, "default", &dcdn.KvNamespaceArgs{
 * 			Description: pulumi.String(name),
 * 			Namespace:   pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewKv(ctx, "default", &dcdn.KvArgs{
 * 			Value:     pulumi.String("example-value"),
 * 			Key:       pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Namespace: defaultKvNamespace.Namespace,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dcdn.KvNamespace;
 * import com.pulumi.alicloud.dcdn.KvNamespaceArgs;
 * import com.pulumi.alicloud.dcdn.Kv;
 * import com.pulumi.alicloud.dcdn.KvArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultKvNamespace = new KvNamespace("defaultKvNamespace", KvNamespaceArgs.builder()
 *             .description(name)
 *             .namespace(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultKv = new Kv("defaultKv", KvArgs.builder()
 *             .value("example-value")
 *             .key(String.format("%s-%s", name,default_.result()))
 *             .namespace(defaultKvNamespace.namespace())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultKvNamespace:
 *     type: alicloud:dcdn:KvNamespace
 *     name: default
 *     properties:
 *       description: ${name}
 *       namespace: ${name}-${default.result}
 *   defaultKv:
 *     type: alicloud:dcdn:Kv
 *     name: default
 *     properties:
 *       value: example-value
 *       key: ${name}-${default.result}
 *       namespace: ${defaultKvNamespace.namespace}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dcdn Kv can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/kv:Kv example <namespace>:<key>
 * ```
 * @property key The name of the key to Put, the longest 512, cannot contain spaces.
 * @property namespace The name specified when the customer calls PutDcdnKvNamespace.
 * @property value The content of key, up to 2M(2*1000*1000).
 */
public data class KvArgs(
    public val key: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.KvArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.KvArgs = com.pulumi.alicloud.dcdn.KvArgs.builder()
        .key(key?.applyValue({ args0 -> args0 }))
        .namespace(namespace?.applyValue({ args0 -> args0 }))
        .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KvArgs].
 */
@PulumiTagMarker
public class KvArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var namespace: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the key to Put, the longest 512, cannot contain spaces.
     */
    @JvmName("aaabamxdeevfopxg")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The name specified when the customer calls PutDcdnKvNamespace.
     */
    @JvmName("nrdrptwthpmlvgev")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The content of key, up to 2M(2*1000*1000).
     */
    @JvmName("sktiupxbtdnacdad")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the key to Put, the longest 512, cannot contain spaces.
     */
    @JvmName("cssdbyhvhblcotlm")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The name specified when the customer calls PutDcdnKvNamespace.
     */
    @JvmName("gtuspstjqnlnqmbv")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The content of key, up to 2M(2*1000*1000).
     */
    @JvmName("tttrdwnhislurqhx")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): KvArgs = KvArgs(
        key = key,
        namespace = namespace,
        `value` = `value`,
    )
}
