@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.KvNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Dcdn Kv Namespace resource.
 * For information about Dcdn Kv Namespace and how to use it, see [What is Kv Namespace](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-putdcdnkvnamespace).
 * > **NOTE:** Available since v1.198.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultKvNamespace = new alicloud.dcdn.KvNamespace("default", {
 *     description: name,
 *     namespace: `${name}-${_default.result}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_kv_namespace = alicloud.dcdn.KvNamespace("default",
 *     description=name,
 *     namespace=f"{name}-{default['result']}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultKvNamespace = new AliCloud.Dcdn.KvNamespace("default", new()
 *     {
 *         Description = name,
 *         Namespace = $"{name}-{@default.Result}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewKvNamespace(ctx, "default", &dcdn.KvNamespaceArgs{
 * 			Description: pulumi.String(name),
 * 			Namespace:   pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dcdn.KvNamespace;
 * import com.pulumi.alicloud.dcdn.KvNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultKvNamespace = new KvNamespace("defaultKvNamespace", KvNamespaceArgs.builder()
 *             .description(name)
 *             .namespace(String.format("%s-%s", name,default_.result()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultKvNamespace:
 *     type: alicloud:dcdn:KvNamespace
 *     name: default
 *     properties:
 *       description: ${name}
 *       namespace: ${name}-${default.result}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dcdn Kv Namespace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/kvNamespace:KvNamespace example
 * ```
 * @property description Namespace description information
 * @property namespace Namespace name. The name can contain letters, digits, hyphens (-), and underscores (_).
 */
public data class KvNamespaceArgs(
    public val description: Output<String>? = null,
    public val namespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.KvNamespaceArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.KvNamespaceArgs =
        com.pulumi.alicloud.dcdn.KvNamespaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KvNamespaceArgs].
 */
@PulumiTagMarker
public class KvNamespaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value Namespace description information
     */
    @JvmName("leabhjofwhdjhffq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Namespace name. The name can contain letters, digits, hyphens (-), and underscores (_).
     */
    @JvmName("adihkswpbhfejeyj")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Namespace description information
     */
    @JvmName("eqliognrxnjrhymu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Namespace name. The name can contain letters, digits, hyphens (-), and underscores (_).
     */
    @JvmName("jgbnyitudxlavwkx")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): KvNamespaceArgs = KvNamespaceArgs(
        description = description,
        namespace = namespace,
    )
}
