@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WafDomain].
 */
@PulumiTagMarker
public class WafDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WafDomainArgs = WafDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WafDomainArgsBuilder.() -> Unit) {
        val builder = WafDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WafDomain {
        val builtJavaResource = com.pulumi.alicloud.dcdn.WafDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WafDomain(builtJavaResource)
    }
}

/**
 * Provides a DCDN Waf Domain resource.
 * For information about DCDN Waf Domain and how to use it, see [What is Waf Domain](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-batchsetdcdnwafdomainconfigs).
 * > **NOTE:** Available since v1.185.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const domainName = config.get("domainName") || "tf-example.com";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.dcdn.Domain("example", {
 *     domainName: `${domainName}-${_default.result}`,
 *     scope: "overseas",
 *     sources: [{
 *         content: "1.1.1.1",
 *         port: 80,
 *         priority: "20",
 *         type: "ipaddr",
 *         weight: "10",
 *     }],
 * });
 * const exampleWafDomain = new alicloud.dcdn.WafDomain("example", {
 *     domainName: example.domainName,
 *     clientIpTag: "X-Forwarded-For",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * domain_name = config.get("domainName")
 * if domain_name is None:
 *     domain_name = "tf-example.com"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.dcdn.Domain("example",
 *     domain_name=f"{domain_name}-{default['result']}",
 *     scope="overseas",
 *     sources=[{
 *         "content": "1.1.1.1",
 *         "port": 80,
 *         "priority": "20",
 *         "type": "ipaddr",
 *         "weight": "10",
 *     }])
 * example_waf_domain = alicloud.dcdn.WafDomain("example",
 *     domain_name=example.domain_name,
 *     client_ip_tag="X-Forwarded-For")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var domainName = config.Get("domainName") ?? "tf-example.com";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.Dcdn.Domain("example", new()
 *     {
 *         DomainName = $"{domainName}-{@default.Result}",
 *         Scope = "overseas",
 *         Sources = new[]
 *         {
 *             new AliCloud.Dcdn.Inputs.DomainSourceArgs
 *             {
 *                 Content = "1.1.1.1",
 *                 Port = 80,
 *                 Priority = "20",
 *                 Type = "ipaddr",
 *                 Weight = "10",
 *             },
 *         },
 *     });
 *     var exampleWafDomain = new AliCloud.Dcdn.WafDomain("example", new()
 *     {
 *         DomainName = example.DomainName,
 *         ClientIpTag = "X-Forwarded-For",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		domainName := "tf-example.com"
 * 		if param := cfg.Get("domainName"); param != "" {
 * 			domainName = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := dcdn.NewDomain(ctx, "example", &dcdn.DomainArgs{
 * 			DomainName: pulumi.Sprintf("%v-%v", domainName, _default.Result),
 * 			Scope:      pulumi.String("overseas"),
 * 			Sources: dcdn.DomainSourceArray{
 * 				&dcdn.DomainSourceArgs{
 * 					Content:  pulumi.String("1.1.1.1"),
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.String("20"),
 * 					Type:     pulumi.String("ipaddr"),
 * 					Weight:   pulumi.String("10"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewWafDomain(ctx, "example", &dcdn.WafDomainArgs{
 * 			DomainName:  example.DomainName,
 * 			ClientIpTag: pulumi.String("X-Forwarded-For"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dcdn.Domain;
 * import com.pulumi.alicloud.dcdn.DomainArgs;
 * import com.pulumi.alicloud.dcdn.inputs.DomainSourceArgs;
 * import com.pulumi.alicloud.dcdn.WafDomain;
 * import com.pulumi.alicloud.dcdn.WafDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var domainName = config.get("domainName").orElse("tf-example.com");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName(String.format("%s-%s", domainName,default_.result()))
 *             .scope("overseas")
 *             .sources(DomainSourceArgs.builder()
 *                 .content("1.1.1.1")
 *                 .port("80")
 *                 .priority("20")
 *                 .type("ipaddr")
 *                 .weight("10")
 *                 .build())
 *             .build());
 *         var exampleWafDomain = new WafDomain("exampleWafDomain", WafDomainArgs.builder()
 *             .domainName(example.domainName())
 *             .clientIpTag("X-Forwarded-For")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   domainName:
 *     type: string
 *     default: tf-example.com
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:dcdn:Domain
 *     properties:
 *       domainName: ${domainName}-${default.result}
 *       scope: overseas
 *       sources:
 *         - content: 1.1.1.1
 *           port: '80'
 *           priority: '20'
 *           type: ipaddr
 *           weight: '10'
 *   exampleWafDomain:
 *     type: alicloud:dcdn:WafDomain
 *     name: example
 *     properties:
 *       domainName: ${example.domainName}
 *       clientIpTag: X-Forwarded-For
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DCDN Waf Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/wafDomain:WafDomain example <domain_name>
 * ```
 */
public class WafDomain internal constructor(
    override val javaResource: com.pulumi.alicloud.dcdn.WafDomain,
) : KotlinCustomResource(javaResource, WafDomainMapper) {
    /**
     * The client ip tag.
     */
    public val clientIpTag: Output<String>?
        get() = javaResource.clientIpTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The accelerated domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })
}

public object WafDomainMapper : ResourceMapper<WafDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dcdn.WafDomain::class == javaResource::class

    override fun map(javaResource: Resource): WafDomain = WafDomain(
        javaResource as
            com.pulumi.alicloud.dcdn.WafDomain,
    )
}

/**
 * @see [WafDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WafDomain].
 */
public suspend fun wafDomain(name: String, block: suspend WafDomainResourceBuilder.() -> Unit): WafDomain {
    val builder = WafDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WafDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun wafDomain(name: String): WafDomain {
    val builder = WafDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
