@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.WafPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DCDN Waf Policy resource.
 * For information about DCDN Waf Policy and how to use it, see [What is Waf Policy](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-createdcdnwafpolicy).
 * > **NOTE:** Available since v1.184.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.dcdn.WafPolicy("example", {
 *     defenseScene: "waf_group",
 *     policyName: `${name}_${_default.result}`,
 *     policyType: "custom",
 *     status: "on",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.dcdn.WafPolicy("example",
 *     defense_scene="waf_group",
 *     policy_name=f"{name}_{default['result']}",
 *     policy_type="custom",
 *     status="on")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.Dcdn.WafPolicy("example", new()
 *     {
 *         DefenseScene = "waf_group",
 *         PolicyName = $"{name}_{@default.Result}",
 *         PolicyType = "custom",
 *         Status = "on",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewWafPolicy(ctx, "example", &dcdn.WafPolicyArgs{
 * 			DefenseScene: pulumi.String("waf_group"),
 * 			PolicyName:   pulumi.Sprintf("%v_%v", name, _default.Result),
 * 			PolicyType:   pulumi.String("custom"),
 * 			Status:       pulumi.String("on"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dcdn.WafPolicy;
 * import com.pulumi.alicloud.dcdn.WafPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new WafPolicy("example", WafPolicyArgs.builder()
 *             .defenseScene("waf_group")
 *             .policyName(String.format("%s_%s", name,default_.result()))
 *             .policyType("custom")
 *             .status("on")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:dcdn:WafPolicy
 *     properties:
 *       defenseScene: waf_group
 *       policyName: ${name}_${default.result}
 *       policyType: custom
 *       status: on
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DCDN Waf Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/wafPolicy:WafPolicy example <id>
 * ```
 * @property defenseScene The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
 * @property policyName The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
 * @property policyType The type of the protection policy. Valid values: `default`, `custom`.
 * @property status The status of the resource. Valid values: `on`, `off`.
 */
public data class WafPolicyArgs(
    public val defenseScene: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val policyType: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.WafPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.WafPolicyArgs =
        com.pulumi.alicloud.dcdn.WafPolicyArgs.builder()
            .defenseScene(defenseScene?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policyType(policyType?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WafPolicyArgs].
 */
@PulumiTagMarker
public class WafPolicyArgsBuilder internal constructor() {
    private var defenseScene: Output<String>? = null

    private var policyName: Output<String>? = null

    private var policyType: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
     */
    @JvmName("nrkcsmljynhvlmgm")
    public suspend fun defenseScene(`value`: Output<String>) {
        this.defenseScene = value
    }

    /**
     * @param value The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
     */
    @JvmName("ywpkjwbglkixpyys")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The type of the protection policy. Valid values: `default`, `custom`.
     */
    @JvmName("pvlxqcemqavntjse")
    public suspend fun policyType(`value`: Output<String>) {
        this.policyType = value
    }

    /**
     * @param value The status of the resource. Valid values: `on`, `off`.
     */
    @JvmName("jpxdwawltykdcguq")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
     */
    @JvmName("jfohpmgxfkmwbvdm")
    public suspend fun defenseScene(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defenseScene = mapped
    }

    /**
     * @param value The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
     */
    @JvmName("tmuavsjpqgeduvpo")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The type of the protection policy. Valid values: `default`, `custom`.
     */
    @JvmName("vkoutjbeqdafvypw")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `on`, `off`.
     */
    @JvmName("lfqkayjpyiuxbjlw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): WafPolicyArgs = WafPolicyArgs(
        defenseScene = defenseScene,
        policyName = policyName,
        policyType = policyType,
        status = status,
    )
}
