@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin

import com.pulumi.alicloud.dcdn.WafRuleArgs.builder
import com.pulumi.alicloud.dcdn.kotlin.inputs.WafRuleConditionArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.WafRuleConditionArgsBuilder
import com.pulumi.alicloud.dcdn.kotlin.inputs.WafRuleRateLimitArgs
import com.pulumi.alicloud.dcdn.kotlin.inputs.WafRuleRateLimitArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Dcdn Waf Rule resource.
 * For information about Dcdn Waf Rule and how to use it, see [What is Waf Rule](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-batchcreatedcdnwafrules).
 * > **NOTE:** Available since v1.201.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.dcdn.WafPolicy("example", {
 *     defenseScene: "waf_group",
 *     policyName: `${name}_${_default.result}`,
 *     policyType: "custom",
 *     status: "on",
 * });
 * const exampleWafRule = new alicloud.dcdn.WafRule("example", {
 *     policyId: example.id,
 *     ruleName: name,
 *     conditions: [
 *         {
 *             key: "URI",
 *             opValue: "ne",
 *             values: "/login.php",
 *         },
 *         {
 *             key: "Header",
 *             subKey: "a",
 *             opValue: "eq",
 *             values: "b",
 *         },
 *     ],
 *     status: "on",
 *     action: "monitor",
 *     rateLimit: {
 *         target: "IP",
 *         interval: 5,
 *         threshold: 5,
 *         ttl: 1800,
 *         status: {
 *             code: "200",
 *             ratio: 60,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.dcdn.WafPolicy("example",
 *     defense_scene="waf_group",
 *     policy_name=f"{name}_{default['result']}",
 *     policy_type="custom",
 *     status="on")
 * example_waf_rule = alicloud.dcdn.WafRule("example",
 *     policy_id=example.id,
 *     rule_name=name,
 *     conditions=[
 *         {
 *             "key": "URI",
 *             "op_value": "ne",
 *             "values": "/login.php",
 *         },
 *         {
 *             "key": "Header",
 *             "sub_key": "a",
 *             "op_value": "eq",
 *             "values": "b",
 *         },
 *     ],
 *     status="on",
 *     action="monitor",
 *     rate_limit={
 *         "target": "IP",
 *         "interval": 5,
 *         "threshold": 5,
 *         "ttl": 1800,
 *         "status": {
 *             "code": "200",
 *             "ratio": 60,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.Dcdn.WafPolicy("example", new()
 *     {
 *         DefenseScene = "waf_group",
 *         PolicyName = $"{name}_{@default.Result}",
 *         PolicyType = "custom",
 *         Status = "on",
 *     });
 *     var exampleWafRule = new AliCloud.Dcdn.WafRule("example", new()
 *     {
 *         PolicyId = example.Id,
 *         RuleName = name,
 *         Conditions = new[]
 *         {
 *             new AliCloud.Dcdn.Inputs.WafRuleConditionArgs
 *             {
 *                 Key = "URI",
 *                 OpValue = "ne",
 *                 Values = "/login.php",
 *             },
 *             new AliCloud.Dcdn.Inputs.WafRuleConditionArgs
 *             {
 *                 Key = "Header",
 *                 SubKey = "a",
 *                 OpValue = "eq",
 *                 Values = "b",
 *             },
 *         },
 *         Status = "on",
 *         Action = "monitor",
 *         RateLimit = new AliCloud.Dcdn.Inputs.WafRuleRateLimitArgs
 *         {
 *             Target = "IP",
 *             Interval = 5,
 *             Threshold = 5,
 *             Ttl = 1800,
 *             Status = new AliCloud.Dcdn.Inputs.WafRuleRateLimitStatusArgs
 *             {
 *                 Code = "200",
 *                 Ratio = 60,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dcdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := dcdn.NewWafPolicy(ctx, "example", &dcdn.WafPolicyArgs{
 * 			DefenseScene: pulumi.String("waf_group"),
 * 			PolicyName:   pulumi.Sprintf("%v_%v", name, _default.Result),
 * 			PolicyType:   pulumi.String("custom"),
 * 			Status:       pulumi.String("on"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dcdn.NewWafRule(ctx, "example", &dcdn.WafRuleArgs{
 * 			PolicyId: example.ID(),
 * 			RuleName: pulumi.String(name),
 * 			Conditions: dcdn.WafRuleConditionArray{
 * 				&dcdn.WafRuleConditionArgs{
 * 					Key:     pulumi.String("URI"),
 * 					OpValue: pulumi.String("ne"),
 * 					Values:  pulumi.String("/login.php"),
 * 				},
 * 				&dcdn.WafRuleConditionArgs{
 * 					Key:     pulumi.String("Header"),
 * 					SubKey:  pulumi.String("a"),
 * 					OpValue: pulumi.String("eq"),
 * 					Values:  pulumi.String("b"),
 * 				},
 * 			},
 * 			Status: pulumi.String("on"),
 * 			Action: pulumi.String("monitor"),
 * 			RateLimit: &dcdn.WafRuleRateLimitArgs{
 * 				Target:    pulumi.String("IP"),
 * 				Interval:  pulumi.Int(5),
 * 				Threshold: pulumi.Int(5),
 * 				Ttl:       pulumi.Int(1800),
 * 				Status: &dcdn.WafRuleRateLimitStatusArgs{
 * 					Code:  pulumi.String("200"),
 * 					Ratio: pulumi.Int(60),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dcdn.WafPolicy;
 * import com.pulumi.alicloud.dcdn.WafPolicyArgs;
 * import com.pulumi.alicloud.dcdn.WafRule;
 * import com.pulumi.alicloud.dcdn.WafRuleArgs;
 * import com.pulumi.alicloud.dcdn.inputs.WafRuleConditionArgs;
 * import com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitArgs;
 * import com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new WafPolicy("example", WafPolicyArgs.builder()
 *             .defenseScene("waf_group")
 *             .policyName(String.format("%s_%s", name,default_.result()))
 *             .policyType("custom")
 *             .status("on")
 *             .build());
 *         var exampleWafRule = new WafRule("exampleWafRule", WafRuleArgs.builder()
 *             .policyId(example.id())
 *             .ruleName(name)
 *             .conditions(
 *                 WafRuleConditionArgs.builder()
 *                     .key("URI")
 *                     .opValue("ne")
 *                     .values("/login.php")
 *                     .build(),
 *                 WafRuleConditionArgs.builder()
 *                     .key("Header")
 *                     .subKey("a")
 *                     .opValue("eq")
 *                     .values("b")
 *                     .build())
 *             .status("on")
 *             .action("monitor")
 *             .rateLimit(WafRuleRateLimitArgs.builder()
 *                 .target("IP")
 *                 .interval("5")
 *                 .threshold("5")
 *                 .ttl("1800")
 *                 .status(WafRuleRateLimitStatusArgs.builder()
 *                     .code("200")
 *                     .ratio("60")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:dcdn:WafPolicy
 *     properties:
 *       defenseScene: waf_group
 *       policyName: ${name}_${default.result}
 *       policyType: custom
 *       status: on
 *   exampleWafRule:
 *     type: alicloud:dcdn:WafRule
 *     name: example
 *     properties:
 *       policyId: ${example.id}
 *       ruleName: ${name}
 *       conditions:
 *         - key: URI
 *           opValue: ne
 *           values: /login.php
 *         - key: Header
 *           subKey: a
 *           opValue: eq
 *           values: b
 *       status: on
 *       action: monitor
 *       rateLimit:
 *         target: IP
 *         interval: '5'
 *         threshold: '5'
 *         ttl: '1800'
 *         status:
 *           code: '200'
 *           ratio: '60'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dcdn Waf Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dcdn/wafRule:WafRule example <id>
 * ```
 * @property action Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
 * @property ccStatus Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
 * @property cnRegionList The blocked regions in the Chinese mainland, separated by commas (,).
 * @property conditions Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
 * @property effect The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
 * @property otherRegionList Blocked regions outside the Chinese mainland, separated by commas (,).
 * @property policyId The protection policy ID.
 * @property rateLimit The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
 * @property regularRules The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
 * @property regularTypes Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
 * @property remoteAddrs Filter by IP address.
 * @property ruleName The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
 * @property scenes The types of the protection policies.
 * @property status The status of the waf rule. Valid values: `on` and `off`. Default value: on.
 * @property wafGroupIds The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
 */
public data class WafRuleArgs(
    public val action: Output<String>? = null,
    public val ccStatus: Output<String>? = null,
    public val cnRegionList: Output<String>? = null,
    public val conditions: Output<List<WafRuleConditionArgs>>? = null,
    public val effect: Output<String>? = null,
    public val otherRegionList: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val rateLimit: Output<WafRuleRateLimitArgs>? = null,
    public val regularRules: Output<List<String>>? = null,
    public val regularTypes: Output<List<String>>? = null,
    public val remoteAddrs: Output<List<String>>? = null,
    public val ruleName: Output<String>? = null,
    public val scenes: Output<List<String>>? = null,
    public val status: Output<String>? = null,
    public val wafGroupIds: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.WafRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.WafRuleArgs =
        com.pulumi.alicloud.dcdn.WafRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .ccStatus(ccStatus?.applyValue({ args0 -> args0 }))
            .cnRegionList(cnRegionList?.applyValue({ args0 -> args0 }))
            .conditions(
                conditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .effect(effect?.applyValue({ args0 -> args0 }))
            .otherRegionList(otherRegionList?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .rateLimit(rateLimit?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regularRules(regularRules?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .regularTypes(regularTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .remoteAddrs(remoteAddrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .scenes(scenes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .wafGroupIds(wafGroupIds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WafRuleArgs].
 */
@PulumiTagMarker
public class WafRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var ccStatus: Output<String>? = null

    private var cnRegionList: Output<String>? = null

    private var conditions: Output<List<WafRuleConditionArgs>>? = null

    private var effect: Output<String>? = null

    private var otherRegionList: Output<String>? = null

    private var policyId: Output<String>? = null

    private var rateLimit: Output<WafRuleRateLimitArgs>? = null

    private var regularRules: Output<List<String>>? = null

    private var regularTypes: Output<List<String>>? = null

    private var remoteAddrs: Output<List<String>>? = null

    private var ruleName: Output<String>? = null

    private var scenes: Output<List<String>>? = null

    private var status: Output<String>? = null

    private var wafGroupIds: Output<String>? = null

    /**
     * @param value Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
     */
    @JvmName("rbbvodwoevrfyrlb")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
     */
    @JvmName("rdpsvjauwtucpjto")
    public suspend fun ccStatus(`value`: Output<String>) {
        this.ccStatus = value
    }

    /**
     * @param value The blocked regions in the Chinese mainland, separated by commas (,).
     */
    @JvmName("eulxmceoetiyexbe")
    public suspend fun cnRegionList(`value`: Output<String>) {
        this.cnRegionList = value
    }

    /**
     * @param value Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
     */
    @JvmName("ompjrhfqneujuxft")
    public suspend fun conditions(`value`: Output<List<WafRuleConditionArgs>>) {
        this.conditions = value
    }

    @JvmName("lxncvjgwaiwmosgi")
    public suspend fun conditions(vararg values: Output<WafRuleConditionArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
     */
    @JvmName("owvocvfcoutlplom")
    public suspend fun conditions(values: List<Output<WafRuleConditionArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
     */
    @JvmName("tmvokwdyvagxbtuv")
    public suspend fun effect(`value`: Output<String>) {
        this.effect = value
    }

    /**
     * @param value Blocked regions outside the Chinese mainland, separated by commas (,).
     */
    @JvmName("sffhnfqkyklnnmgk")
    public suspend fun otherRegionList(`value`: Output<String>) {
        this.otherRegionList = value
    }

    /**
     * @param value The protection policy ID.
     */
    @JvmName("quqkchofcggdkryc")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
     */
    @JvmName("kuoebiseptuiqtva")
    public suspend fun rateLimit(`value`: Output<WafRuleRateLimitArgs>) {
        this.rateLimit = value
    }

    /**
     * @param value The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
     */
    @JvmName("tjilksdmkrrjmcbm")
    public suspend fun regularRules(`value`: Output<List<String>>) {
        this.regularRules = value
    }

    @JvmName("txwscnnifnntkfcd")
    public suspend fun regularRules(vararg values: Output<String>) {
        this.regularRules = Output.all(values.asList())
    }

    /**
     * @param values The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
     */
    @JvmName("gjosxylwvogaywkt")
    public suspend fun regularRules(values: List<Output<String>>) {
        this.regularRules = Output.all(values)
    }

    /**
     * @param value Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
     */
    @JvmName("dfdsfybwgnkcfrnx")
    public suspend fun regularTypes(`value`: Output<List<String>>) {
        this.regularTypes = value
    }

    @JvmName("rehyhdcwtetgdeeq")
    public suspend fun regularTypes(vararg values: Output<String>) {
        this.regularTypes = Output.all(values.asList())
    }

    /**
     * @param values Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
     */
    @JvmName("govwpbcdonviqnke")
    public suspend fun regularTypes(values: List<Output<String>>) {
        this.regularTypes = Output.all(values)
    }

    /**
     * @param value Filter by IP address.
     */
    @JvmName("iyqkoatwriugpcwa")
    public suspend fun remoteAddrs(`value`: Output<List<String>>) {
        this.remoteAddrs = value
    }

    @JvmName("sxrfdjqpdjkyrqws")
    public suspend fun remoteAddrs(vararg values: Output<String>) {
        this.remoteAddrs = Output.all(values.asList())
    }

    /**
     * @param values Filter by IP address.
     */
    @JvmName("qfcbufhtmamkioxu")
    public suspend fun remoteAddrs(values: List<Output<String>>) {
        this.remoteAddrs = Output.all(values)
    }

    /**
     * @param value The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
     */
    @JvmName("huurprpfxgwfrucq")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The types of the protection policies.
     */
    @JvmName("xjkwrmgbsvkskbwt")
    public suspend fun scenes(`value`: Output<List<String>>) {
        this.scenes = value
    }

    @JvmName("rxxrliicdyplejbr")
    public suspend fun scenes(vararg values: Output<String>) {
        this.scenes = Output.all(values.asList())
    }

    /**
     * @param values The types of the protection policies.
     */
    @JvmName("rikokuvtrwnbfjxn")
    public suspend fun scenes(values: List<Output<String>>) {
        this.scenes = Output.all(values)
    }

    /**
     * @param value The status of the waf rule. Valid values: `on` and `off`. Default value: on.
     */
    @JvmName("hwqdvukwcohkykys")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
     */
    @JvmName("wkyokuodbisvhuhv")
    public suspend fun wafGroupIds(`value`: Output<String>) {
        this.wafGroupIds = value
    }

    /**
     * @param value Specifies the action of the rule. Valid values: `block`, `monitor`, `js`.
     */
    @JvmName("xydnnsyiytjijchy")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Specifies whether to enable rate limiting. Valid values: `on` and `off`. **NOTE:** This parameter is required when policy is of type `custom_acl`.
     */
    @JvmName("fcsmaobrmlauykrr")
    public suspend fun ccStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ccStatus = mapped
    }

    /**
     * @param value The blocked regions in the Chinese mainland, separated by commas (,).
     */
    @JvmName("excsjtpcltimsacc")
    public suspend fun cnRegionList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cnRegionList = mapped
    }

    /**
     * @param value Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
     */
    @JvmName("tbpugnggkthihosj")
    public suspend fun conditions(`value`: List<WafRuleConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
     */
    @JvmName("qjfdaqvcfrogstmm")
    public suspend fun conditions(argument: List<suspend WafRuleConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WafRuleConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
     */
    @JvmName("aqwmcauohewgnffd")
    public suspend fun conditions(vararg argument: suspend WafRuleConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WafRuleConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
     */
    @JvmName("gsfprxcxfhwfkbwq")
    public suspend fun conditions(argument: suspend WafRuleConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WafRuleConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values Conditions that trigger the rule. See `conditions` below. **NOTE:** This parameter is required when policy is of type `custom_acl` or `whitelist`.
     */
    @JvmName("mjcrntxnjrqcviwx")
    public suspend fun conditions(vararg values: WafRuleConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value The effective scope of the rate limiting blacklist. If you set ccStatus to on, you must configure this parameter. Valid values: `rule` (takes effect for the current rule) and `service` (takes effect globally).
     */
    @JvmName("tdnelondggqprodc")
    public suspend fun effect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value Blocked regions outside the Chinese mainland, separated by commas (,).
     */
    @JvmName("ypdkirfpqhmhiuee")
    public suspend fun otherRegionList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.otherRegionList = mapped
    }

    /**
     * @param value The protection policy ID.
     */
    @JvmName("yqdiwvbqpuquesgj")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
     */
    @JvmName("cbdcvhxmcxjaxisj")
    public suspend fun rateLimit(`value`: WafRuleRateLimitArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimit = mapped
    }

    /**
     * @param argument The rules of rate limiting. If you set `cc_status` to on, you must configure this parameter. See `rate_limit` below.
     */
    @JvmName("qjfbfphoobopkyrm")
    public suspend fun rateLimit(argument: suspend WafRuleRateLimitArgsBuilder.() -> Unit) {
        val toBeMapped = WafRuleRateLimitArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rateLimit = mapped
    }

    /**
     * @param value The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
     */
    @JvmName("ghfwjabhtkwpnbot")
    public suspend fun regularRules(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regularRules = mapped
    }

    /**
     * @param values The regular expression.e, when waf_group appears in tags, this value can be filled in, and only one list of six digits in string format can appear with regultypes.
     */
    @JvmName("wxmvserdvwqatqsh")
    public suspend fun regularRules(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regularRules = mapped
    }

    /**
     * @param value Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
     */
    @JvmName("ymshtxhrsaqaxhfo")
    public suspend fun regularTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regularTypes = mapped
    }

    /**
     * @param values Regular rule type, when waf_group appears in tags, this value can be filled in, optional values:["sqli", "xss", "code_exec", "crlf", "lfileii", "rfileii", "webshell", "vvip", "other"]
     */
    @JvmName("nsdqulxgfhjtcsfc")
    public suspend fun regularTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regularTypes = mapped
    }

    /**
     * @param value Filter by IP address.
     */
    @JvmName("metvqihkiwysohxr")
    public suspend fun remoteAddrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteAddrs = mapped
    }

    /**
     * @param values Filter by IP address.
     */
    @JvmName("vjbjjldjavewpdfi")
    public suspend fun remoteAddrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteAddrs = mapped
    }

    /**
     * @param value The name of the protection rule. The name can be up to 64 characters in length and can contain letters, digits, and underscores (_). **NOTE:** This parameter cannot be modified when policy is of type `region_block`.
     */
    @JvmName("ftkwaswhrchpkkeu")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The types of the protection policies.
     */
    @JvmName("fwxaasvucfabhbdt")
    public suspend fun scenes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scenes = mapped
    }

    /**
     * @param values The types of the protection policies.
     */
    @JvmName("sadhigcwcnpiiovl")
    public suspend fun scenes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scenes = mapped
    }

    /**
     * @param value The status of the waf rule. Valid values: `on` and `off`. Default value: on.
     */
    @JvmName("sfypetiwwvyfxjph")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The id of the waf rule group. The default value is "1012". Multiple rules are separated by commas.
     */
    @JvmName("amdiywwuttcnlmpt")
    public suspend fun wafGroupIds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wafGroupIds = mapped
    }

    internal fun build(): WafRuleArgs = WafRuleArgs(
        action = action,
        ccStatus = ccStatus,
        cnRegionList = cnRegionList,
        conditions = conditions,
        effect = effect,
        otherRegionList = otherRegionList,
        policyId = policyId,
        rateLimit = rateLimit,
        regularRules = regularRules,
        regularTypes = regularTypes,
        remoteAddrs = remoteAddrs,
        ruleName = ruleName,
        scenes = scenes,
        status = status,
        wafGroupIds = wafGroupIds,
    )
}
