@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.DomainSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The address of the source station.
 * @property port The port number. Valid values: `443` and `80`. Default to `80`.
 * @property priority The priority of the origin if multiple origins are specified. Default to `20`.
 * @property type The type of the origin. Valid values:
 * @property weight The weight of the origin if multiple origins are specified. Default to `10`.
 */
public data class DomainSourceArgs(
    public val content: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val priority: Output<String>? = null,
    public val type: Output<String>? = null,
    public val weight: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.DomainSourceArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.DomainSourceArgs =
        com.pulumi.alicloud.dcdn.inputs.DomainSourceArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainSourceArgs].
 */
@PulumiTagMarker
public class DomainSourceArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var port: Output<Int>? = null

    private var priority: Output<String>? = null

    private var type: Output<String>? = null

    private var weight: Output<String>? = null

    /**
     * @param value The address of the source station.
     */
    @JvmName("bmsqqafhkrpfuwwu")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The port number. Valid values: `443` and `80`. Default to `80`.
     */
    @JvmName("apmuyfwooximdjre")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The priority of the origin if multiple origins are specified. Default to `20`.
     */
    @JvmName("oapguihbonarjxkx")
    public suspend fun priority(`value`: Output<String>) {
        this.priority = value
    }

    /**
     * @param value The type of the origin. Valid values:
     */
    @JvmName("spfecrufipwagvbf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The weight of the origin if multiple origins are specified. Default to `10`.
     */
    @JvmName("aqjjvtvuutcsyoeq")
    public suspend fun weight(`value`: Output<String>) {
        this.weight = value
    }

    /**
     * @param value The address of the source station.
     */
    @JvmName("xcyqvhjtbiqfuccw")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The port number. Valid values: `443` and `80`. Default to `80`.
     */
    @JvmName("ycomicdwrggxwhld")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The priority of the origin if multiple origins are specified. Default to `20`.
     */
    @JvmName("jngtjcpgutajttoq")
    public suspend fun priority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The type of the origin. Valid values:
     */
    @JvmName("wotulcjcigdcoibu")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The weight of the origin if multiple origins are specified. Default to `10`.
     */
    @JvmName("ipdsmqnyweinqhvi")
    public suspend fun weight(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): DomainSourceArgs = DomainSourceArgs(
        content = content,
        port = port,
        priority = priority,
        type = type,
        weight = weight,
    )
}
