@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.ErEnvConfArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property presetCanaryAnhui The configuration of a presetCanaryAnhui environment. See `staging` below.
 * @property presetCanaryBeijing The configuration of a presetCanaryBeijing environment. See `staging` below.
 * @property presetCanaryChongqing The configuration of a presetCanaryChongqing environment. See `staging` below.
 * @property presetCanaryFujian The configuration of a presetCanaryFujian environment. See `staging` below.
 * @property presetCanaryGansu The configuration of a presetCanaryGansu environment. See `staging` below.
 * @property presetCanaryGuangdong The configuration of a presetCanaryGuangdong environment. See `staging` below.
 * @property presetCanaryGuangxi The configuration of a presetCanaryGuangxi environment. See `staging` below.
 * @property presetCanaryGuizhou The configuration of a presetCanaryGuizhou environment. See `staging` below.
 * @property presetCanaryHainan The configuration of a presetCanaryHainan environment. See `staging` below.
 * @property presetCanaryHebei The configuration of a presetCanaryHebei environment. See `staging` below.
 * @property presetCanaryHeilongjiang The configuration of a presetCanaryHeilongjiang environment. See `staging` below.
 * @property presetCanaryHenan The configuration of a presetCanaryHenan environment. See `staging` below.
 * @property presetCanaryHongKong The configuration of a presetCanaryHongKong environment. See `staging` below.
 * @property presetCanaryHubei The configuration of a presetCanaryHubei environment. See `staging` below.
 * @property presetCanaryHunan The configuration of a presetCanaryHunan environment. See `staging` below.
 * @property presetCanaryJiangsu The configuration of a presetCanaryJiangsu environment. See `staging` below.
 * @property presetCanaryJiangxi The configuration of a presetCanaryJiangxi environment. See `staging` below.
 * @property presetCanaryJilin The configuration of a presetCanaryJilin environment. See `staging` below.
 * @property presetCanaryLiaoning The configuration of a presetCanaryLiaoning environment. See `staging` below.
 * @property presetCanaryMacau The configuration of a presetCanaryMacau environment. See `staging` below.
 * @property presetCanaryNeimenggu The configuration of a presetCanaryNeimenggu environment. See `staging` below.
 * @property presetCanaryNingxia The configuration of a presetCanaryNingxia environment. See `staging` below.
 * @property presetCanaryOverseas The configuration of a presetCanaryOverseas environment. See `staging` below.
 * @property presetCanaryQinghai The configuration of a presetCanaryQinghai environment. See `staging` below.
 * @property presetCanaryShaanxi The configuration of a presetCanaryShaanxi environment. See `staging` below.
 * @property presetCanaryShandong The configuration of a presetCanaryShandong environment. See `staging` below.
 * @property presetCanaryShanghai The configuration of a presetCanaryShanghai environment. See `staging` below.
 * @property presetCanaryShanxi The configuration of a presetCanaryShanxi environment. See `staging` below.
 * @property presetCanarySichuan The configuration of a presetCanarySichuan environment. See `staging` below.
 * @property presetCanaryTaiwan The configuration of a presetCanaryTaiwan environment. See `staging` below.
 * @property presetCanaryTianjin The configuration of a presetCanaryTianjin environment. See `staging` below.
 * @property presetCanaryXinjiang The configuration of a presetCanaryXinjiang environment. See `staging` below.
 * @property presetCanaryXizang The configuration of a presetCanaryXizang environment. See `staging` below.
 * @property presetCanaryYunnan The configuration of a presetCanaryYunnan environment. See `staging` below.
 * @property presetCanaryZhejiang The configuration of a presetCanaryZhejiang environment. See `staging` below.
 * @property production The configuration of a production environment. See `staging` below.
 * @property staging The configuration of a staging environment. See `staging` below.
 */
public data class ErEnvConfArgs(
    public val presetCanaryAnhui: Output<ErEnvConfPresetCanaryAnhuiArgs>? = null,
    public val presetCanaryBeijing: Output<ErEnvConfPresetCanaryBeijingArgs>? = null,
    public val presetCanaryChongqing: Output<ErEnvConfPresetCanaryChongqingArgs>? = null,
    public val presetCanaryFujian: Output<ErEnvConfPresetCanaryFujianArgs>? = null,
    public val presetCanaryGansu: Output<ErEnvConfPresetCanaryGansuArgs>? = null,
    public val presetCanaryGuangdong: Output<ErEnvConfPresetCanaryGuangdongArgs>? = null,
    public val presetCanaryGuangxi: Output<ErEnvConfPresetCanaryGuangxiArgs>? = null,
    public val presetCanaryGuizhou: Output<ErEnvConfPresetCanaryGuizhouArgs>? = null,
    public val presetCanaryHainan: Output<ErEnvConfPresetCanaryHainanArgs>? = null,
    public val presetCanaryHebei: Output<ErEnvConfPresetCanaryHebeiArgs>? = null,
    public val presetCanaryHeilongjiang: Output<ErEnvConfPresetCanaryHeilongjiangArgs>? = null,
    public val presetCanaryHenan: Output<ErEnvConfPresetCanaryHenanArgs>? = null,
    public val presetCanaryHongKong: Output<ErEnvConfPresetCanaryHongKongArgs>? = null,
    public val presetCanaryHubei: Output<ErEnvConfPresetCanaryHubeiArgs>? = null,
    public val presetCanaryHunan: Output<ErEnvConfPresetCanaryHunanArgs>? = null,
    public val presetCanaryJiangsu: Output<ErEnvConfPresetCanaryJiangsuArgs>? = null,
    public val presetCanaryJiangxi: Output<ErEnvConfPresetCanaryJiangxiArgs>? = null,
    public val presetCanaryJilin: Output<ErEnvConfPresetCanaryJilinArgs>? = null,
    public val presetCanaryLiaoning: Output<ErEnvConfPresetCanaryLiaoningArgs>? = null,
    public val presetCanaryMacau: Output<ErEnvConfPresetCanaryMacauArgs>? = null,
    public val presetCanaryNeimenggu: Output<ErEnvConfPresetCanaryNeimengguArgs>? = null,
    public val presetCanaryNingxia: Output<ErEnvConfPresetCanaryNingxiaArgs>? = null,
    public val presetCanaryOverseas: Output<ErEnvConfPresetCanaryOverseasArgs>? = null,
    public val presetCanaryQinghai: Output<ErEnvConfPresetCanaryQinghaiArgs>? = null,
    public val presetCanaryShaanxi: Output<ErEnvConfPresetCanaryShaanxiArgs>? = null,
    public val presetCanaryShandong: Output<ErEnvConfPresetCanaryShandongArgs>? = null,
    public val presetCanaryShanghai: Output<ErEnvConfPresetCanaryShanghaiArgs>? = null,
    public val presetCanaryShanxi: Output<ErEnvConfPresetCanaryShanxiArgs>? = null,
    public val presetCanarySichuan: Output<ErEnvConfPresetCanarySichuanArgs>? = null,
    public val presetCanaryTaiwan: Output<ErEnvConfPresetCanaryTaiwanArgs>? = null,
    public val presetCanaryTianjin: Output<ErEnvConfPresetCanaryTianjinArgs>? = null,
    public val presetCanaryXinjiang: Output<ErEnvConfPresetCanaryXinjiangArgs>? = null,
    public val presetCanaryXizang: Output<ErEnvConfPresetCanaryXizangArgs>? = null,
    public val presetCanaryYunnan: Output<ErEnvConfPresetCanaryYunnanArgs>? = null,
    public val presetCanaryZhejiang: Output<ErEnvConfPresetCanaryZhejiangArgs>? = null,
    public val production: Output<ErEnvConfProductionArgs>? = null,
    public val staging: Output<ErEnvConfStagingArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.ErEnvConfArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.ErEnvConfArgs =
        com.pulumi.alicloud.dcdn.inputs.ErEnvConfArgs.builder()
            .presetCanaryAnhui(presetCanaryAnhui?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presetCanaryBeijing(
                presetCanaryBeijing?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryChongqing(
                presetCanaryChongqing?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryFujian(
                presetCanaryFujian?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryGansu(presetCanaryGansu?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presetCanaryGuangdong(
                presetCanaryGuangdong?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryGuangxi(
                presetCanaryGuangxi?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryGuizhou(
                presetCanaryGuizhou?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryHainan(
                presetCanaryHainan?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryHebei(presetCanaryHebei?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presetCanaryHeilongjiang(
                presetCanaryHeilongjiang?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryHenan(presetCanaryHenan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presetCanaryHongKong(
                presetCanaryHongKong?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryHubei(presetCanaryHubei?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presetCanaryHunan(presetCanaryHunan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presetCanaryJiangsu(
                presetCanaryJiangsu?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryJiangxi(
                presetCanaryJiangxi?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryJilin(presetCanaryJilin?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presetCanaryLiaoning(
                presetCanaryLiaoning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryMacau(presetCanaryMacau?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presetCanaryNeimenggu(
                presetCanaryNeimenggu?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryNingxia(
                presetCanaryNingxia?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryOverseas(
                presetCanaryOverseas?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryQinghai(
                presetCanaryQinghai?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryShaanxi(
                presetCanaryShaanxi?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryShandong(
                presetCanaryShandong?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryShanghai(
                presetCanaryShanghai?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryShanxi(
                presetCanaryShanxi?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanarySichuan(
                presetCanarySichuan?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryTaiwan(
                presetCanaryTaiwan?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryTianjin(
                presetCanaryTianjin?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryXinjiang(
                presetCanaryXinjiang?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryXizang(
                presetCanaryXizang?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryYunnan(
                presetCanaryYunnan?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .presetCanaryZhejiang(
                presetCanaryZhejiang?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .production(production?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .staging(staging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ErEnvConfArgs].
 */
@PulumiTagMarker
public class ErEnvConfArgsBuilder internal constructor() {
    private var presetCanaryAnhui: Output<ErEnvConfPresetCanaryAnhuiArgs>? = null

    private var presetCanaryBeijing: Output<ErEnvConfPresetCanaryBeijingArgs>? = null

    private var presetCanaryChongqing: Output<ErEnvConfPresetCanaryChongqingArgs>? = null

    private var presetCanaryFujian: Output<ErEnvConfPresetCanaryFujianArgs>? = null

    private var presetCanaryGansu: Output<ErEnvConfPresetCanaryGansuArgs>? = null

    private var presetCanaryGuangdong: Output<ErEnvConfPresetCanaryGuangdongArgs>? = null

    private var presetCanaryGuangxi: Output<ErEnvConfPresetCanaryGuangxiArgs>? = null

    private var presetCanaryGuizhou: Output<ErEnvConfPresetCanaryGuizhouArgs>? = null

    private var presetCanaryHainan: Output<ErEnvConfPresetCanaryHainanArgs>? = null

    private var presetCanaryHebei: Output<ErEnvConfPresetCanaryHebeiArgs>? = null

    private var presetCanaryHeilongjiang: Output<ErEnvConfPresetCanaryHeilongjiangArgs>? = null

    private var presetCanaryHenan: Output<ErEnvConfPresetCanaryHenanArgs>? = null

    private var presetCanaryHongKong: Output<ErEnvConfPresetCanaryHongKongArgs>? = null

    private var presetCanaryHubei: Output<ErEnvConfPresetCanaryHubeiArgs>? = null

    private var presetCanaryHunan: Output<ErEnvConfPresetCanaryHunanArgs>? = null

    private var presetCanaryJiangsu: Output<ErEnvConfPresetCanaryJiangsuArgs>? = null

    private var presetCanaryJiangxi: Output<ErEnvConfPresetCanaryJiangxiArgs>? = null

    private var presetCanaryJilin: Output<ErEnvConfPresetCanaryJilinArgs>? = null

    private var presetCanaryLiaoning: Output<ErEnvConfPresetCanaryLiaoningArgs>? = null

    private var presetCanaryMacau: Output<ErEnvConfPresetCanaryMacauArgs>? = null

    private var presetCanaryNeimenggu: Output<ErEnvConfPresetCanaryNeimengguArgs>? = null

    private var presetCanaryNingxia: Output<ErEnvConfPresetCanaryNingxiaArgs>? = null

    private var presetCanaryOverseas: Output<ErEnvConfPresetCanaryOverseasArgs>? = null

    private var presetCanaryQinghai: Output<ErEnvConfPresetCanaryQinghaiArgs>? = null

    private var presetCanaryShaanxi: Output<ErEnvConfPresetCanaryShaanxiArgs>? = null

    private var presetCanaryShandong: Output<ErEnvConfPresetCanaryShandongArgs>? = null

    private var presetCanaryShanghai: Output<ErEnvConfPresetCanaryShanghaiArgs>? = null

    private var presetCanaryShanxi: Output<ErEnvConfPresetCanaryShanxiArgs>? = null

    private var presetCanarySichuan: Output<ErEnvConfPresetCanarySichuanArgs>? = null

    private var presetCanaryTaiwan: Output<ErEnvConfPresetCanaryTaiwanArgs>? = null

    private var presetCanaryTianjin: Output<ErEnvConfPresetCanaryTianjinArgs>? = null

    private var presetCanaryXinjiang: Output<ErEnvConfPresetCanaryXinjiangArgs>? = null

    private var presetCanaryXizang: Output<ErEnvConfPresetCanaryXizangArgs>? = null

    private var presetCanaryYunnan: Output<ErEnvConfPresetCanaryYunnanArgs>? = null

    private var presetCanaryZhejiang: Output<ErEnvConfPresetCanaryZhejiangArgs>? = null

    private var production: Output<ErEnvConfProductionArgs>? = null

    private var staging: Output<ErEnvConfStagingArgs>? = null

    /**
     * @param value The configuration of a presetCanaryAnhui environment. See `staging` below.
     */
    @JvmName("itlchegwgtyvhtxk")
    public suspend fun presetCanaryAnhui(`value`: Output<ErEnvConfPresetCanaryAnhuiArgs>) {
        this.presetCanaryAnhui = value
    }

    /**
     * @param value The configuration of a presetCanaryBeijing environment. See `staging` below.
     */
    @JvmName("sdebkgaueuvvtcyk")
    public suspend fun presetCanaryBeijing(`value`: Output<ErEnvConfPresetCanaryBeijingArgs>) {
        this.presetCanaryBeijing = value
    }

    /**
     * @param value The configuration of a presetCanaryChongqing environment. See `staging` below.
     */
    @JvmName("ektjhektviahjruc")
    public suspend fun presetCanaryChongqing(`value`: Output<ErEnvConfPresetCanaryChongqingArgs>) {
        this.presetCanaryChongqing = value
    }

    /**
     * @param value The configuration of a presetCanaryFujian environment. See `staging` below.
     */
    @JvmName("txtcmydobfpanyln")
    public suspend fun presetCanaryFujian(`value`: Output<ErEnvConfPresetCanaryFujianArgs>) {
        this.presetCanaryFujian = value
    }

    /**
     * @param value The configuration of a presetCanaryGansu environment. See `staging` below.
     */
    @JvmName("duahnvefxqmekjnn")
    public suspend fun presetCanaryGansu(`value`: Output<ErEnvConfPresetCanaryGansuArgs>) {
        this.presetCanaryGansu = value
    }

    /**
     * @param value The configuration of a presetCanaryGuangdong environment. See `staging` below.
     */
    @JvmName("akdjqwwhmqxvbnsb")
    public suspend fun presetCanaryGuangdong(`value`: Output<ErEnvConfPresetCanaryGuangdongArgs>) {
        this.presetCanaryGuangdong = value
    }

    /**
     * @param value The configuration of a presetCanaryGuangxi environment. See `staging` below.
     */
    @JvmName("powaoeetigjsfjgf")
    public suspend fun presetCanaryGuangxi(`value`: Output<ErEnvConfPresetCanaryGuangxiArgs>) {
        this.presetCanaryGuangxi = value
    }

    /**
     * @param value The configuration of a presetCanaryGuizhou environment. See `staging` below.
     */
    @JvmName("shphbttgyucpvyob")
    public suspend fun presetCanaryGuizhou(`value`: Output<ErEnvConfPresetCanaryGuizhouArgs>) {
        this.presetCanaryGuizhou = value
    }

    /**
     * @param value The configuration of a presetCanaryHainan environment. See `staging` below.
     */
    @JvmName("ysjoatyjslnbmton")
    public suspend fun presetCanaryHainan(`value`: Output<ErEnvConfPresetCanaryHainanArgs>) {
        this.presetCanaryHainan = value
    }

    /**
     * @param value The configuration of a presetCanaryHebei environment. See `staging` below.
     */
    @JvmName("ewqfqbvpjwhotcbj")
    public suspend fun presetCanaryHebei(`value`: Output<ErEnvConfPresetCanaryHebeiArgs>) {
        this.presetCanaryHebei = value
    }

    /**
     * @param value The configuration of a presetCanaryHeilongjiang environment. See `staging` below.
     */
    @JvmName("owyeidqajbdsekmk")
    public suspend fun presetCanaryHeilongjiang(`value`: Output<ErEnvConfPresetCanaryHeilongjiangArgs>) {
        this.presetCanaryHeilongjiang = value
    }

    /**
     * @param value The configuration of a presetCanaryHenan environment. See `staging` below.
     */
    @JvmName("emmxmvmsvwftoqvn")
    public suspend fun presetCanaryHenan(`value`: Output<ErEnvConfPresetCanaryHenanArgs>) {
        this.presetCanaryHenan = value
    }

    /**
     * @param value The configuration of a presetCanaryHongKong environment. See `staging` below.
     */
    @JvmName("yobklxfibdhlvcle")
    public suspend fun presetCanaryHongKong(`value`: Output<ErEnvConfPresetCanaryHongKongArgs>) {
        this.presetCanaryHongKong = value
    }

    /**
     * @param value The configuration of a presetCanaryHubei environment. See `staging` below.
     */
    @JvmName("ftjeoqxnhdrnbaoy")
    public suspend fun presetCanaryHubei(`value`: Output<ErEnvConfPresetCanaryHubeiArgs>) {
        this.presetCanaryHubei = value
    }

    /**
     * @param value The configuration of a presetCanaryHunan environment. See `staging` below.
     */
    @JvmName("liwnwwndkyxyuaih")
    public suspend fun presetCanaryHunan(`value`: Output<ErEnvConfPresetCanaryHunanArgs>) {
        this.presetCanaryHunan = value
    }

    /**
     * @param value The configuration of a presetCanaryJiangsu environment. See `staging` below.
     */
    @JvmName("amvrqciavgpmyavo")
    public suspend fun presetCanaryJiangsu(`value`: Output<ErEnvConfPresetCanaryJiangsuArgs>) {
        this.presetCanaryJiangsu = value
    }

    /**
     * @param value The configuration of a presetCanaryJiangxi environment. See `staging` below.
     */
    @JvmName("bxoqhrmiaraahptj")
    public suspend fun presetCanaryJiangxi(`value`: Output<ErEnvConfPresetCanaryJiangxiArgs>) {
        this.presetCanaryJiangxi = value
    }

    /**
     * @param value The configuration of a presetCanaryJilin environment. See `staging` below.
     */
    @JvmName("qlnqatqinuleljia")
    public suspend fun presetCanaryJilin(`value`: Output<ErEnvConfPresetCanaryJilinArgs>) {
        this.presetCanaryJilin = value
    }

    /**
     * @param value The configuration of a presetCanaryLiaoning environment. See `staging` below.
     */
    @JvmName("vdkojdjwbysxguvg")
    public suspend fun presetCanaryLiaoning(`value`: Output<ErEnvConfPresetCanaryLiaoningArgs>) {
        this.presetCanaryLiaoning = value
    }

    /**
     * @param value The configuration of a presetCanaryMacau environment. See `staging` below.
     */
    @JvmName("lcwgyucjoehpmwgk")
    public suspend fun presetCanaryMacau(`value`: Output<ErEnvConfPresetCanaryMacauArgs>) {
        this.presetCanaryMacau = value
    }

    /**
     * @param value The configuration of a presetCanaryNeimenggu environment. See `staging` below.
     */
    @JvmName("qrnmugsgsiumjigb")
    public suspend fun presetCanaryNeimenggu(`value`: Output<ErEnvConfPresetCanaryNeimengguArgs>) {
        this.presetCanaryNeimenggu = value
    }

    /**
     * @param value The configuration of a presetCanaryNingxia environment. See `staging` below.
     */
    @JvmName("ossmouluosyexehc")
    public suspend fun presetCanaryNingxia(`value`: Output<ErEnvConfPresetCanaryNingxiaArgs>) {
        this.presetCanaryNingxia = value
    }

    /**
     * @param value The configuration of a presetCanaryOverseas environment. See `staging` below.
     */
    @JvmName("sevxjwfsubqeilfp")
    public suspend fun presetCanaryOverseas(`value`: Output<ErEnvConfPresetCanaryOverseasArgs>) {
        this.presetCanaryOverseas = value
    }

    /**
     * @param value The configuration of a presetCanaryQinghai environment. See `staging` below.
     */
    @JvmName("oiuylrgjwaotiqik")
    public suspend fun presetCanaryQinghai(`value`: Output<ErEnvConfPresetCanaryQinghaiArgs>) {
        this.presetCanaryQinghai = value
    }

    /**
     * @param value The configuration of a presetCanaryShaanxi environment. See `staging` below.
     */
    @JvmName("jnjpccqxoxutspii")
    public suspend fun presetCanaryShaanxi(`value`: Output<ErEnvConfPresetCanaryShaanxiArgs>) {
        this.presetCanaryShaanxi = value
    }

    /**
     * @param value The configuration of a presetCanaryShandong environment. See `staging` below.
     */
    @JvmName("wtucxvqhqpvwhogg")
    public suspend fun presetCanaryShandong(`value`: Output<ErEnvConfPresetCanaryShandongArgs>) {
        this.presetCanaryShandong = value
    }

    /**
     * @param value The configuration of a presetCanaryShanghai environment. See `staging` below.
     */
    @JvmName("lhuqjngewyxknjmk")
    public suspend fun presetCanaryShanghai(`value`: Output<ErEnvConfPresetCanaryShanghaiArgs>) {
        this.presetCanaryShanghai = value
    }

    /**
     * @param value The configuration of a presetCanaryShanxi environment. See `staging` below.
     */
    @JvmName("gbkgraopwqtjvpit")
    public suspend fun presetCanaryShanxi(`value`: Output<ErEnvConfPresetCanaryShanxiArgs>) {
        this.presetCanaryShanxi = value
    }

    /**
     * @param value The configuration of a presetCanarySichuan environment. See `staging` below.
     */
    @JvmName("ramchsqcgkydqnky")
    public suspend fun presetCanarySichuan(`value`: Output<ErEnvConfPresetCanarySichuanArgs>) {
        this.presetCanarySichuan = value
    }

    /**
     * @param value The configuration of a presetCanaryTaiwan environment. See `staging` below.
     */
    @JvmName("uxpyfvoshatxahcg")
    public suspend fun presetCanaryTaiwan(`value`: Output<ErEnvConfPresetCanaryTaiwanArgs>) {
        this.presetCanaryTaiwan = value
    }

    /**
     * @param value The configuration of a presetCanaryTianjin environment. See `staging` below.
     */
    @JvmName("qsykxjiftlyivsvv")
    public suspend fun presetCanaryTianjin(`value`: Output<ErEnvConfPresetCanaryTianjinArgs>) {
        this.presetCanaryTianjin = value
    }

    /**
     * @param value The configuration of a presetCanaryXinjiang environment. See `staging` below.
     */
    @JvmName("sgjthgihslmmkesm")
    public suspend fun presetCanaryXinjiang(`value`: Output<ErEnvConfPresetCanaryXinjiangArgs>) {
        this.presetCanaryXinjiang = value
    }

    /**
     * @param value The configuration of a presetCanaryXizang environment. See `staging` below.
     */
    @JvmName("ltudgbmlrlbcykal")
    public suspend fun presetCanaryXizang(`value`: Output<ErEnvConfPresetCanaryXizangArgs>) {
        this.presetCanaryXizang = value
    }

    /**
     * @param value The configuration of a presetCanaryYunnan environment. See `staging` below.
     */
    @JvmName("oqlmwfsirpgrkoer")
    public suspend fun presetCanaryYunnan(`value`: Output<ErEnvConfPresetCanaryYunnanArgs>) {
        this.presetCanaryYunnan = value
    }

    /**
     * @param value The configuration of a presetCanaryZhejiang environment. See `staging` below.
     */
    @JvmName("jvltiecwmmwxbbcr")
    public suspend fun presetCanaryZhejiang(`value`: Output<ErEnvConfPresetCanaryZhejiangArgs>) {
        this.presetCanaryZhejiang = value
    }

    /**
     * @param value The configuration of a production environment. See `staging` below.
     */
    @JvmName("metbmnmghignhdar")
    public suspend fun production(`value`: Output<ErEnvConfProductionArgs>) {
        this.production = value
    }

    /**
     * @param value The configuration of a staging environment. See `staging` below.
     */
    @JvmName("yfbjmurhjwmsvgar")
    public suspend fun staging(`value`: Output<ErEnvConfStagingArgs>) {
        this.staging = value
    }

    /**
     * @param value The configuration of a presetCanaryAnhui environment. See `staging` below.
     */
    @JvmName("vfbeldhrnlaukkjy")
    public suspend fun presetCanaryAnhui(`value`: ErEnvConfPresetCanaryAnhuiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryAnhui = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryAnhui environment. See `staging` below.
     */
    @JvmName("ocalmlpwecoudibm")
    public suspend fun presetCanaryAnhui(argument: suspend ErEnvConfPresetCanaryAnhuiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryAnhuiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryAnhui = mapped
    }

    /**
     * @param value The configuration of a presetCanaryBeijing environment. See `staging` below.
     */
    @JvmName("sfktdrpxaohrtihu")
    public suspend fun presetCanaryBeijing(`value`: ErEnvConfPresetCanaryBeijingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryBeijing = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryBeijing environment. See `staging` below.
     */
    @JvmName("ktajcvepvyfkjfyd")
    public suspend fun presetCanaryBeijing(argument: suspend ErEnvConfPresetCanaryBeijingArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryBeijingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryBeijing = mapped
    }

    /**
     * @param value The configuration of a presetCanaryChongqing environment. See `staging` below.
     */
    @JvmName("ksgvwaaoujbfailk")
    public suspend fun presetCanaryChongqing(`value`: ErEnvConfPresetCanaryChongqingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryChongqing = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryChongqing environment. See `staging` below.
     */
    @JvmName("vkqwvayddnwolnxo")
    public suspend fun presetCanaryChongqing(argument: suspend ErEnvConfPresetCanaryChongqingArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryChongqingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryChongqing = mapped
    }

    /**
     * @param value The configuration of a presetCanaryFujian environment. See `staging` below.
     */
    @JvmName("cauyfdmmviqpasst")
    public suspend fun presetCanaryFujian(`value`: ErEnvConfPresetCanaryFujianArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryFujian = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryFujian environment. See `staging` below.
     */
    @JvmName("pdwqxxhxpkhydikq")
    public suspend fun presetCanaryFujian(argument: suspend ErEnvConfPresetCanaryFujianArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryFujianArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryFujian = mapped
    }

    /**
     * @param value The configuration of a presetCanaryGansu environment. See `staging` below.
     */
    @JvmName("diyntpaoyqogfihm")
    public suspend fun presetCanaryGansu(`value`: ErEnvConfPresetCanaryGansuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryGansu = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryGansu environment. See `staging` below.
     */
    @JvmName("uohoimmwghexjyov")
    public suspend fun presetCanaryGansu(argument: suspend ErEnvConfPresetCanaryGansuArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryGansuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryGansu = mapped
    }

    /**
     * @param value The configuration of a presetCanaryGuangdong environment. See `staging` below.
     */
    @JvmName("piwodllbtrxskybi")
    public suspend fun presetCanaryGuangdong(`value`: ErEnvConfPresetCanaryGuangdongArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryGuangdong = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryGuangdong environment. See `staging` below.
     */
    @JvmName("ooyberxputjwetxv")
    public suspend fun presetCanaryGuangdong(argument: suspend ErEnvConfPresetCanaryGuangdongArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryGuangdongArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryGuangdong = mapped
    }

    /**
     * @param value The configuration of a presetCanaryGuangxi environment. See `staging` below.
     */
    @JvmName("bwpnimtxklqfbnrx")
    public suspend fun presetCanaryGuangxi(`value`: ErEnvConfPresetCanaryGuangxiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryGuangxi = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryGuangxi environment. See `staging` below.
     */
    @JvmName("ybmiumpkixsyhxha")
    public suspend fun presetCanaryGuangxi(argument: suspend ErEnvConfPresetCanaryGuangxiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryGuangxiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryGuangxi = mapped
    }

    /**
     * @param value The configuration of a presetCanaryGuizhou environment. See `staging` below.
     */
    @JvmName("xriqdxmqywbqmttb")
    public suspend fun presetCanaryGuizhou(`value`: ErEnvConfPresetCanaryGuizhouArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryGuizhou = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryGuizhou environment. See `staging` below.
     */
    @JvmName("tnkerelqvaaukqjg")
    public suspend fun presetCanaryGuizhou(argument: suspend ErEnvConfPresetCanaryGuizhouArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryGuizhouArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryGuizhou = mapped
    }

    /**
     * @param value The configuration of a presetCanaryHainan environment. See `staging` below.
     */
    @JvmName("aqyyutppfwakqsox")
    public suspend fun presetCanaryHainan(`value`: ErEnvConfPresetCanaryHainanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryHainan = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryHainan environment. See `staging` below.
     */
    @JvmName("ohdqltxbboxeoyic")
    public suspend fun presetCanaryHainan(argument: suspend ErEnvConfPresetCanaryHainanArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryHainanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryHainan = mapped
    }

    /**
     * @param value The configuration of a presetCanaryHebei environment. See `staging` below.
     */
    @JvmName("ojeooxtoucdrtbhf")
    public suspend fun presetCanaryHebei(`value`: ErEnvConfPresetCanaryHebeiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryHebei = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryHebei environment. See `staging` below.
     */
    @JvmName("xcxteyndgosdpjuk")
    public suspend fun presetCanaryHebei(argument: suspend ErEnvConfPresetCanaryHebeiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryHebeiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryHebei = mapped
    }

    /**
     * @param value The configuration of a presetCanaryHeilongjiang environment. See `staging` below.
     */
    @JvmName("qysclwwuavbxhpaa")
    public suspend fun presetCanaryHeilongjiang(`value`: ErEnvConfPresetCanaryHeilongjiangArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryHeilongjiang = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryHeilongjiang environment. See `staging` below.
     */
    @JvmName("uoolfgyieekycaep")
    public suspend fun presetCanaryHeilongjiang(argument: suspend ErEnvConfPresetCanaryHeilongjiangArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryHeilongjiangArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryHeilongjiang = mapped
    }

    /**
     * @param value The configuration of a presetCanaryHenan environment. See `staging` below.
     */
    @JvmName("anmsullsjyoqdxuf")
    public suspend fun presetCanaryHenan(`value`: ErEnvConfPresetCanaryHenanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryHenan = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryHenan environment. See `staging` below.
     */
    @JvmName("nodagpalvtfiqess")
    public suspend fun presetCanaryHenan(argument: suspend ErEnvConfPresetCanaryHenanArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryHenanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryHenan = mapped
    }

    /**
     * @param value The configuration of a presetCanaryHongKong environment. See `staging` below.
     */
    @JvmName("mtfjhioifrblwwfx")
    public suspend fun presetCanaryHongKong(`value`: ErEnvConfPresetCanaryHongKongArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryHongKong = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryHongKong environment. See `staging` below.
     */
    @JvmName("pfcniolutolrowan")
    public suspend fun presetCanaryHongKong(argument: suspend ErEnvConfPresetCanaryHongKongArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryHongKongArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryHongKong = mapped
    }

    /**
     * @param value The configuration of a presetCanaryHubei environment. See `staging` below.
     */
    @JvmName("jcfntsovdovyysnt")
    public suspend fun presetCanaryHubei(`value`: ErEnvConfPresetCanaryHubeiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryHubei = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryHubei environment. See `staging` below.
     */
    @JvmName("ulwlwqbqjfhjueag")
    public suspend fun presetCanaryHubei(argument: suspend ErEnvConfPresetCanaryHubeiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryHubeiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryHubei = mapped
    }

    /**
     * @param value The configuration of a presetCanaryHunan environment. See `staging` below.
     */
    @JvmName("vipkxhlsknqktmog")
    public suspend fun presetCanaryHunan(`value`: ErEnvConfPresetCanaryHunanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryHunan = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryHunan environment. See `staging` below.
     */
    @JvmName("hdrxqvlbqtndjmyj")
    public suspend fun presetCanaryHunan(argument: suspend ErEnvConfPresetCanaryHunanArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryHunanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryHunan = mapped
    }

    /**
     * @param value The configuration of a presetCanaryJiangsu environment. See `staging` below.
     */
    @JvmName("gmxmeogoqkwwwcbb")
    public suspend fun presetCanaryJiangsu(`value`: ErEnvConfPresetCanaryJiangsuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryJiangsu = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryJiangsu environment. See `staging` below.
     */
    @JvmName("stlenlxamupiuvgj")
    public suspend fun presetCanaryJiangsu(argument: suspend ErEnvConfPresetCanaryJiangsuArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryJiangsuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryJiangsu = mapped
    }

    /**
     * @param value The configuration of a presetCanaryJiangxi environment. See `staging` below.
     */
    @JvmName("oaqfbhsssjbfiwia")
    public suspend fun presetCanaryJiangxi(`value`: ErEnvConfPresetCanaryJiangxiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryJiangxi = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryJiangxi environment. See `staging` below.
     */
    @JvmName("bvmfphhubuypfojv")
    public suspend fun presetCanaryJiangxi(argument: suspend ErEnvConfPresetCanaryJiangxiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryJiangxiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryJiangxi = mapped
    }

    /**
     * @param value The configuration of a presetCanaryJilin environment. See `staging` below.
     */
    @JvmName("tigoutrombwstowd")
    public suspend fun presetCanaryJilin(`value`: ErEnvConfPresetCanaryJilinArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryJilin = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryJilin environment. See `staging` below.
     */
    @JvmName("qblqhnvogvlajfje")
    public suspend fun presetCanaryJilin(argument: suspend ErEnvConfPresetCanaryJilinArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryJilinArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryJilin = mapped
    }

    /**
     * @param value The configuration of a presetCanaryLiaoning environment. See `staging` below.
     */
    @JvmName("dimdtasxpwhnekpp")
    public suspend fun presetCanaryLiaoning(`value`: ErEnvConfPresetCanaryLiaoningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryLiaoning = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryLiaoning environment. See `staging` below.
     */
    @JvmName("djxhvwgcnqqnwbie")
    public suspend fun presetCanaryLiaoning(argument: suspend ErEnvConfPresetCanaryLiaoningArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryLiaoningArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryLiaoning = mapped
    }

    /**
     * @param value The configuration of a presetCanaryMacau environment. See `staging` below.
     */
    @JvmName("vaomvewbhiodimfr")
    public suspend fun presetCanaryMacau(`value`: ErEnvConfPresetCanaryMacauArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryMacau = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryMacau environment. See `staging` below.
     */
    @JvmName("kbjwjnjlkivlmske")
    public suspend fun presetCanaryMacau(argument: suspend ErEnvConfPresetCanaryMacauArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryMacauArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryMacau = mapped
    }

    /**
     * @param value The configuration of a presetCanaryNeimenggu environment. See `staging` below.
     */
    @JvmName("sissmmklybdmeddn")
    public suspend fun presetCanaryNeimenggu(`value`: ErEnvConfPresetCanaryNeimengguArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryNeimenggu = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryNeimenggu environment. See `staging` below.
     */
    @JvmName("aihtfvliicxywxlv")
    public suspend fun presetCanaryNeimenggu(argument: suspend ErEnvConfPresetCanaryNeimengguArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryNeimengguArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryNeimenggu = mapped
    }

    /**
     * @param value The configuration of a presetCanaryNingxia environment. See `staging` below.
     */
    @JvmName("rjkhlovifvgrrfll")
    public suspend fun presetCanaryNingxia(`value`: ErEnvConfPresetCanaryNingxiaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryNingxia = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryNingxia environment. See `staging` below.
     */
    @JvmName("wlmwxsnyxxfnnmvr")
    public suspend fun presetCanaryNingxia(argument: suspend ErEnvConfPresetCanaryNingxiaArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryNingxiaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryNingxia = mapped
    }

    /**
     * @param value The configuration of a presetCanaryOverseas environment. See `staging` below.
     */
    @JvmName("mdhltjvxdjbelesi")
    public suspend fun presetCanaryOverseas(`value`: ErEnvConfPresetCanaryOverseasArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryOverseas = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryOverseas environment. See `staging` below.
     */
    @JvmName("mpcdwvvnifwgyfnh")
    public suspend fun presetCanaryOverseas(argument: suspend ErEnvConfPresetCanaryOverseasArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryOverseasArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryOverseas = mapped
    }

    /**
     * @param value The configuration of a presetCanaryQinghai environment. See `staging` below.
     */
    @JvmName("lekasljorshmfvlc")
    public suspend fun presetCanaryQinghai(`value`: ErEnvConfPresetCanaryQinghaiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryQinghai = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryQinghai environment. See `staging` below.
     */
    @JvmName("cuuthlxfxujwbnel")
    public suspend fun presetCanaryQinghai(argument: suspend ErEnvConfPresetCanaryQinghaiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryQinghaiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryQinghai = mapped
    }

    /**
     * @param value The configuration of a presetCanaryShaanxi environment. See `staging` below.
     */
    @JvmName("lwisssanjmwefcfl")
    public suspend fun presetCanaryShaanxi(`value`: ErEnvConfPresetCanaryShaanxiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryShaanxi = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryShaanxi environment. See `staging` below.
     */
    @JvmName("kbclseisonwsdjmv")
    public suspend fun presetCanaryShaanxi(argument: suspend ErEnvConfPresetCanaryShaanxiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryShaanxiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryShaanxi = mapped
    }

    /**
     * @param value The configuration of a presetCanaryShandong environment. See `staging` below.
     */
    @JvmName("koelybrgsujlwsrf")
    public suspend fun presetCanaryShandong(`value`: ErEnvConfPresetCanaryShandongArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryShandong = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryShandong environment. See `staging` below.
     */
    @JvmName("aimdkcbhmtudhcoq")
    public suspend fun presetCanaryShandong(argument: suspend ErEnvConfPresetCanaryShandongArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryShandongArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryShandong = mapped
    }

    /**
     * @param value The configuration of a presetCanaryShanghai environment. See `staging` below.
     */
    @JvmName("ryigmmoatfxlucjm")
    public suspend fun presetCanaryShanghai(`value`: ErEnvConfPresetCanaryShanghaiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryShanghai = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryShanghai environment. See `staging` below.
     */
    @JvmName("joaeyyoflxviyyoo")
    public suspend fun presetCanaryShanghai(argument: suspend ErEnvConfPresetCanaryShanghaiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryShanghaiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryShanghai = mapped
    }

    /**
     * @param value The configuration of a presetCanaryShanxi environment. See `staging` below.
     */
    @JvmName("cxrjhgsnubwbwwqf")
    public suspend fun presetCanaryShanxi(`value`: ErEnvConfPresetCanaryShanxiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryShanxi = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryShanxi environment. See `staging` below.
     */
    @JvmName("yvevqnxsrtqvtyyo")
    public suspend fun presetCanaryShanxi(argument: suspend ErEnvConfPresetCanaryShanxiArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryShanxiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryShanxi = mapped
    }

    /**
     * @param value The configuration of a presetCanarySichuan environment. See `staging` below.
     */
    @JvmName("wneyhwrahlubobkd")
    public suspend fun presetCanarySichuan(`value`: ErEnvConfPresetCanarySichuanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanarySichuan = mapped
    }

    /**
     * @param argument The configuration of a presetCanarySichuan environment. See `staging` below.
     */
    @JvmName("gdjxnnuujpujbbde")
    public suspend fun presetCanarySichuan(argument: suspend ErEnvConfPresetCanarySichuanArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanarySichuanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanarySichuan = mapped
    }

    /**
     * @param value The configuration of a presetCanaryTaiwan environment. See `staging` below.
     */
    @JvmName("quqafrmusnqhdret")
    public suspend fun presetCanaryTaiwan(`value`: ErEnvConfPresetCanaryTaiwanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryTaiwan = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryTaiwan environment. See `staging` below.
     */
    @JvmName("xgicqqcwkeipxuyd")
    public suspend fun presetCanaryTaiwan(argument: suspend ErEnvConfPresetCanaryTaiwanArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryTaiwanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryTaiwan = mapped
    }

    /**
     * @param value The configuration of a presetCanaryTianjin environment. See `staging` below.
     */
    @JvmName("uhbrijpayrclchvl")
    public suspend fun presetCanaryTianjin(`value`: ErEnvConfPresetCanaryTianjinArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryTianjin = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryTianjin environment. See `staging` below.
     */
    @JvmName("rduevtsmkqmqbwob")
    public suspend fun presetCanaryTianjin(argument: suspend ErEnvConfPresetCanaryTianjinArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryTianjinArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryTianjin = mapped
    }

    /**
     * @param value The configuration of a presetCanaryXinjiang environment. See `staging` below.
     */
    @JvmName("mbhivfkbvwmernru")
    public suspend fun presetCanaryXinjiang(`value`: ErEnvConfPresetCanaryXinjiangArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryXinjiang = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryXinjiang environment. See `staging` below.
     */
    @JvmName("uwjtfvhwjvapyeth")
    public suspend fun presetCanaryXinjiang(argument: suspend ErEnvConfPresetCanaryXinjiangArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryXinjiangArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryXinjiang = mapped
    }

    /**
     * @param value The configuration of a presetCanaryXizang environment. See `staging` below.
     */
    @JvmName("dgprtlxbwewqhnry")
    public suspend fun presetCanaryXizang(`value`: ErEnvConfPresetCanaryXizangArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryXizang = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryXizang environment. See `staging` below.
     */
    @JvmName("tvfdpuawefrglxtk")
    public suspend fun presetCanaryXizang(argument: suspend ErEnvConfPresetCanaryXizangArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryXizangArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryXizang = mapped
    }

    /**
     * @param value The configuration of a presetCanaryYunnan environment. See `staging` below.
     */
    @JvmName("yvrldbmoucurvstn")
    public suspend fun presetCanaryYunnan(`value`: ErEnvConfPresetCanaryYunnanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryYunnan = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryYunnan environment. See `staging` below.
     */
    @JvmName("mxtihuobkmhvmwof")
    public suspend fun presetCanaryYunnan(argument: suspend ErEnvConfPresetCanaryYunnanArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryYunnanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryYunnan = mapped
    }

    /**
     * @param value The configuration of a presetCanaryZhejiang environment. See `staging` below.
     */
    @JvmName("ycwfthtfmsuxwipk")
    public suspend fun presetCanaryZhejiang(`value`: ErEnvConfPresetCanaryZhejiangArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetCanaryZhejiang = mapped
    }

    /**
     * @param argument The configuration of a presetCanaryZhejiang environment. See `staging` below.
     */
    @JvmName("stywkoehesnsrfme")
    public suspend fun presetCanaryZhejiang(argument: suspend ErEnvConfPresetCanaryZhejiangArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfPresetCanaryZhejiangArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presetCanaryZhejiang = mapped
    }

    /**
     * @param value The configuration of a production environment. See `staging` below.
     */
    @JvmName("goelkxqarvjvtvbk")
    public suspend fun production(`value`: ErEnvConfProductionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.production = mapped
    }

    /**
     * @param argument The configuration of a production environment. See `staging` below.
     */
    @JvmName("psdldydforvunymy")
    public suspend fun production(argument: suspend ErEnvConfProductionArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfProductionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.production = mapped
    }

    /**
     * @param value The configuration of a staging environment. See `staging` below.
     */
    @JvmName("qafqyfmamxmnljcu")
    public suspend fun staging(`value`: ErEnvConfStagingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staging = mapped
    }

    /**
     * @param argument The configuration of a staging environment. See `staging` below.
     */
    @JvmName("nrirecnuojjqeydt")
    public suspend fun staging(argument: suspend ErEnvConfStagingArgsBuilder.() -> Unit) {
        val toBeMapped = ErEnvConfStagingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.staging = mapped
    }

    internal fun build(): ErEnvConfArgs = ErEnvConfArgs(
        presetCanaryAnhui = presetCanaryAnhui,
        presetCanaryBeijing = presetCanaryBeijing,
        presetCanaryChongqing = presetCanaryChongqing,
        presetCanaryFujian = presetCanaryFujian,
        presetCanaryGansu = presetCanaryGansu,
        presetCanaryGuangdong = presetCanaryGuangdong,
        presetCanaryGuangxi = presetCanaryGuangxi,
        presetCanaryGuizhou = presetCanaryGuizhou,
        presetCanaryHainan = presetCanaryHainan,
        presetCanaryHebei = presetCanaryHebei,
        presetCanaryHeilongjiang = presetCanaryHeilongjiang,
        presetCanaryHenan = presetCanaryHenan,
        presetCanaryHongKong = presetCanaryHongKong,
        presetCanaryHubei = presetCanaryHubei,
        presetCanaryHunan = presetCanaryHunan,
        presetCanaryJiangsu = presetCanaryJiangsu,
        presetCanaryJiangxi = presetCanaryJiangxi,
        presetCanaryJilin = presetCanaryJilin,
        presetCanaryLiaoning = presetCanaryLiaoning,
        presetCanaryMacau = presetCanaryMacau,
        presetCanaryNeimenggu = presetCanaryNeimenggu,
        presetCanaryNingxia = presetCanaryNingxia,
        presetCanaryOverseas = presetCanaryOverseas,
        presetCanaryQinghai = presetCanaryQinghai,
        presetCanaryShaanxi = presetCanaryShaanxi,
        presetCanaryShandong = presetCanaryShandong,
        presetCanaryShanghai = presetCanaryShanghai,
        presetCanaryShanxi = presetCanaryShanxi,
        presetCanarySichuan = presetCanarySichuan,
        presetCanaryTaiwan = presetCanaryTaiwan,
        presetCanaryTianjin = presetCanaryTianjin,
        presetCanaryXinjiang = presetCanaryXinjiang,
        presetCanaryXizang = presetCanaryXizang,
        presetCanaryYunnan = presetCanaryYunnan,
        presetCanaryZhejiang = presetCanaryZhejiang,
        production = production,
        staging = staging,
    )
}
