@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.ErEnvConfPresetCanaryQinghaiArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedHosts Allowed DCDN domain names.
 * @property codeRev The version number of the code.
 * @property specName The specification of the CPU time slice. Valid values: `5ms`, `50ms`, `100ms`.
 */
public data class ErEnvConfPresetCanaryQinghaiArgs(
    public val allowedHosts: Output<List<String>>? = null,
    public val codeRev: Output<String>? = null,
    public val specName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.ErEnvConfPresetCanaryQinghaiArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.ErEnvConfPresetCanaryQinghaiArgs =
        com.pulumi.alicloud.dcdn.inputs.ErEnvConfPresetCanaryQinghaiArgs.builder()
            .allowedHosts(allowedHosts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .codeRev(codeRev?.applyValue({ args0 -> args0 }))
            .specName(specName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ErEnvConfPresetCanaryQinghaiArgs].
 */
@PulumiTagMarker
public class ErEnvConfPresetCanaryQinghaiArgsBuilder internal constructor() {
    private var allowedHosts: Output<List<String>>? = null

    private var codeRev: Output<String>? = null

    private var specName: Output<String>? = null

    /**
     * @param value Allowed DCDN domain names.
     */
    @JvmName("uhgcvovfbbhxtqhd")
    public suspend fun allowedHosts(`value`: Output<List<String>>) {
        this.allowedHosts = value
    }

    @JvmName("oggwfawdgexerqjp")
    public suspend fun allowedHosts(vararg values: Output<String>) {
        this.allowedHosts = Output.all(values.asList())
    }

    /**
     * @param values Allowed DCDN domain names.
     */
    @JvmName("oiwovjkwqmqkficx")
    public suspend fun allowedHosts(values: List<Output<String>>) {
        this.allowedHosts = Output.all(values)
    }

    /**
     * @param value The version number of the code.
     */
    @JvmName("xtarhdhismcsuwyw")
    public suspend fun codeRev(`value`: Output<String>) {
        this.codeRev = value
    }

    /**
     * @param value The specification of the CPU time slice. Valid values: `5ms`, `50ms`, `100ms`.
     */
    @JvmName("oiyeatxfckqfwjkj")
    public suspend fun specName(`value`: Output<String>) {
        this.specName = value
    }

    /**
     * @param value Allowed DCDN domain names.
     */
    @JvmName("jtkdxdktlyqoenoi")
    public suspend fun allowedHosts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHosts = mapped
    }

    /**
     * @param values Allowed DCDN domain names.
     */
    @JvmName("kpmnvquxffxogdfk")
    public suspend fun allowedHosts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHosts = mapped
    }

    /**
     * @param value The version number of the code.
     */
    @JvmName("tlboklqpgoaqytxi")
    public suspend fun codeRev(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRev = mapped
    }

    /**
     * @param value The specification of the CPU time slice. Valid values: `5ms`, `50ms`, `100ms`.
     */
    @JvmName("foqwfriojqbtidst")
    public suspend fun specName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specName = mapped
    }

    internal fun build(): ErEnvConfPresetCanaryQinghaiArgs = ErEnvConfPresetCanaryQinghaiArgs(
        allowedHosts = allowedHosts,
        codeRev = codeRev,
        specName = specName,
    )
}
