@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.ErEnvConfPresetCanaryXinjiangArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedHosts Allowed DCDN domain names.
 * @property codeRev The version number of the code.
 * @property specName The specification of the CPU time slice. Valid values: `5ms`, `50ms`, `100ms`.
 */
public data class ErEnvConfPresetCanaryXinjiangArgs(
    public val allowedHosts: Output<List<String>>? = null,
    public val codeRev: Output<String>? = null,
    public val specName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.ErEnvConfPresetCanaryXinjiangArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.ErEnvConfPresetCanaryXinjiangArgs =
        com.pulumi.alicloud.dcdn.inputs.ErEnvConfPresetCanaryXinjiangArgs.builder()
            .allowedHosts(allowedHosts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .codeRev(codeRev?.applyValue({ args0 -> args0 }))
            .specName(specName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ErEnvConfPresetCanaryXinjiangArgs].
 */
@PulumiTagMarker
public class ErEnvConfPresetCanaryXinjiangArgsBuilder internal constructor() {
    private var allowedHosts: Output<List<String>>? = null

    private var codeRev: Output<String>? = null

    private var specName: Output<String>? = null

    /**
     * @param value Allowed DCDN domain names.
     */
    @JvmName("nyunmmvnoyplrmwq")
    public suspend fun allowedHosts(`value`: Output<List<String>>) {
        this.allowedHosts = value
    }

    @JvmName("ujlsnsvkiolrytmr")
    public suspend fun allowedHosts(vararg values: Output<String>) {
        this.allowedHosts = Output.all(values.asList())
    }

    /**
     * @param values Allowed DCDN domain names.
     */
    @JvmName("ngdygodsccgtqrsi")
    public suspend fun allowedHosts(values: List<Output<String>>) {
        this.allowedHosts = Output.all(values)
    }

    /**
     * @param value The version number of the code.
     */
    @JvmName("olufdbtetcbulvrr")
    public suspend fun codeRev(`value`: Output<String>) {
        this.codeRev = value
    }

    /**
     * @param value The specification of the CPU time slice. Valid values: `5ms`, `50ms`, `100ms`.
     */
    @JvmName("huuygstsbjmkkabb")
    public suspend fun specName(`value`: Output<String>) {
        this.specName = value
    }

    /**
     * @param value Allowed DCDN domain names.
     */
    @JvmName("uukbsmvikrqdvcgy")
    public suspend fun allowedHosts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHosts = mapped
    }

    /**
     * @param values Allowed DCDN domain names.
     */
    @JvmName("nfsgfifcogymuqbm")
    public suspend fun allowedHosts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHosts = mapped
    }

    /**
     * @param value The version number of the code.
     */
    @JvmName("qhpyphqpwtklqnxv")
    public suspend fun codeRev(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRev = mapped
    }

    /**
     * @param value The specification of the CPU time slice. Valid values: `5ms`, `50ms`, `100ms`.
     */
    @JvmName("nwqnhqfjhvyounhg")
    public suspend fun specName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specName = mapped
    }

    internal fun build(): ErEnvConfPresetCanaryXinjiangArgs = ErEnvConfPresetCanaryXinjiangArgs(
        allowedHosts = allowedHosts,
        codeRev = codeRev,
        specName = specName,
    )
}
