@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.GetDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomains.
 * @property changeEndTime The end time of the update. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
 * @property changeStartTime The start time of the update. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
 * @property checkDomainShow Specifies whether to display the domains in the checking, check_failed, or configure_failed status. Valid values: `true` or `false`.
 * @property domainSearchType The search method. Default value: `fuzzy_match`. Valid values: `fuzzy_match`, `pre_match`, `suf_match`, `full_match`.
 * @property enableDetails Default to `false`. Set it to true can output more details.
 * @property ids A list ids of DCDN Domain.
 * @property nameRegex A regex string to filter results by the DCDN Domain.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group.
 * @property securityToken
 * @property status The status of DCDN Domain.
 */
public data class GetDomainsPlainArgs(
    public val changeEndTime: String? = null,
    public val changeStartTime: String? = null,
    public val checkDomainShow: Boolean? = null,
    public val domainSearchType: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val securityToken: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.GetDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.GetDomainsPlainArgs =
        com.pulumi.alicloud.dcdn.inputs.GetDomainsPlainArgs.builder()
            .changeEndTime(changeEndTime?.let({ args0 -> args0 }))
            .changeStartTime(changeStartTime?.let({ args0 -> args0 }))
            .checkDomainShow(checkDomainShow?.let({ args0 -> args0 }))
            .domainSearchType(domainSearchType?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .securityToken(securityToken?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetDomainsPlainArgsBuilder internal constructor() {
    private var changeEndTime: String? = null

    private var changeStartTime: String? = null

    private var checkDomainShow: Boolean? = null

    private var domainSearchType: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var securityToken: String? = null

    private var status: String? = null

    /**
     * @param value The end time of the update. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
     */
    @JvmName("hkqubdieccavoift")
    public suspend fun changeEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.changeEndTime = mapped
    }

    /**
     * @param value The start time of the update. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC.
     */
    @JvmName("nclnsgxhvqbbibvk")
    public suspend fun changeStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.changeStartTime = mapped
    }

    /**
     * @param value Specifies whether to display the domains in the checking, check_failed, or configure_failed status. Valid values: `true` or `false`.
     */
    @JvmName("eglvabnqadyalwxi")
    public suspend fun checkDomainShow(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.checkDomainShow = mapped
    }

    /**
     * @param value The search method. Default value: `fuzzy_match`. Valid values: `fuzzy_match`, `pre_match`, `suf_match`, `full_match`.
     */
    @JvmName("xkavpajdfsejaurs")
    public suspend fun domainSearchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainSearchType = mapped
    }

    /**
     * @param value Default to `false`. Set it to true can output more details.
     */
    @JvmName("byyikgsyejdfnlqr")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list ids of DCDN Domain.
     */
    @JvmName("dkefbynwcohqevwu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list ids of DCDN Domain.
     */
    @JvmName("hgwnipmajkqfaklf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by the DCDN Domain.
     */
    @JvmName("xovcqaltfwbyivao")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sixskuvybrdemdbx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("vkicccotfusutbwq")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("jbshdhwsbywwvsff")
    public suspend fun securityToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityToken = mapped
    }

    /**
     * @param value The status of DCDN Domain.
     */
    @JvmName("yqnaypuklqtupuiv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDomainsPlainArgs = GetDomainsPlainArgs(
        changeEndTime = changeEndTime,
        changeStartTime = changeStartTime,
        checkDomainShow = checkDomainShow,
        domainSearchType = domainSearchType,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        securityToken = securityToken,
        status = status,
    )
}
