@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.GetIpaDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpaDomains.
 * @property domainName The name of the Domain.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Ipa Domain IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the accelerated domain name. Valid values: `check_failed`, `checking`, `configure_failed`, `configuring`, `offline`, `online`.
 */
public data class GetIpaDomainsPlainArgs(
    public val domainName: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.GetIpaDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.GetIpaDomainsPlainArgs =
        com.pulumi.alicloud.dcdn.inputs.GetIpaDomainsPlainArgs.builder()
            .domainName(domainName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpaDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetIpaDomainsPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The name of the Domain.
     */
    @JvmName("rwslgikcplwwafap")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("pfsuqtphwluhlccm")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Ipa Domain IDs.
     */
    @JvmName("kdgndtgoxqpradqm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ipa Domain IDs.
     */
    @JvmName("rhhjdjofpunwmywl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tswrdnfeuphbllwi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the accelerated domain name. Valid values: `check_failed`, `checking`, `configure_failed`, `configuring`, `offline`, `online`.
     */
    @JvmName("vtmtnauucxrymhpm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetIpaDomainsPlainArgs = GetIpaDomainsPlainArgs(
        domainName = domainName,
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
