@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.GetKvAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKvAccount.
 * @property status The status of the KV feature for your account. Valid values: `online`, `offline`.
 */
public data class GetKvAccountPlainArgs(
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.GetKvAccountPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.GetKvAccountPlainArgs =
        com.pulumi.alicloud.dcdn.inputs.GetKvAccountPlainArgs.builder()
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKvAccountPlainArgs].
 */
@PulumiTagMarker
public class GetKvAccountPlainArgsBuilder internal constructor() {
    private var status: String? = null

    /**
     * @param value The status of the KV feature for your account. Valid values: `online`, `offline`.
     */
    @JvmName("kjvfthdhtbabdafc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetKvAccountPlainArgs = GetKvAccountPlainArgs(
        status = status,
    )
}
