@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.GetWafDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWafDomains.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Waf Domain IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property queryArgs The query conditions. You can filter domain names by name. Fuzzy match is supported `QueryArgs={"DomainName":"Accelerated domain name"}`.
 */
public data class GetWafDomainsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val queryArgs: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.GetWafDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.GetWafDomainsPlainArgs =
        com.pulumi.alicloud.dcdn.inputs.GetWafDomainsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .queryArgs(queryArgs?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWafDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetWafDomainsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var queryArgs: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("puthqsgcimoqxwes")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Waf Domain IDs.
     */
    @JvmName("rakiokntrgbjygpl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Waf Domain IDs.
     */
    @JvmName("unkrxxokfxigefdh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("trhihykkekkhjngh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The query conditions. You can filter domain names by name. Fuzzy match is supported `QueryArgs={"DomainName":"Accelerated domain name"}`.
     */
    @JvmName("lspjbqjqxtiuulol")
    public suspend fun queryArgs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryArgs = mapped
    }

    internal fun build(): GetWafDomainsPlainArgs = GetWafDomainsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        queryArgs = queryArgs,
    )
}
