@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.GetWafRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWafRules.
 * @property ids A list of Waf Rule IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property queryArgs The query conditions. The value is a string in the JSON format.
 */
public data class GetWafRulesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val queryArgs: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.GetWafRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.GetWafRulesPlainArgs =
        com.pulumi.alicloud.dcdn.inputs.GetWafRulesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .queryArgs(queryArgs?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWafRulesPlainArgs].
 */
@PulumiTagMarker
public class GetWafRulesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var queryArgs: String? = null

    /**
     * @param value A list of Waf Rule IDs.
     */
    @JvmName("iheehtuuslhochmm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Waf Rule IDs.
     */
    @JvmName("wafrhrtpyainerdq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yupamsxjmoeajfyf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("pfrxlkvhvcidyytc")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("psdatveqorlxnqfy")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The query conditions. The value is a string in the JSON format.
     */
    @JvmName("xtrqogbcpdgrppyk")
    public suspend fun queryArgs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryArgs = mapped
    }

    internal fun build(): GetWafRulesPlainArgs = GetWafRulesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        queryArgs = queryArgs,
    )
}
