@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.IpaDomainSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The address of the origin server. You can specify an IP address or a domain name.
 * @property port The custom port number. Valid values: `0` to `65535`.
 * @property priority The priority of the origin server. Valid values: `20` and `30`. Default value: `20`. A value of 20 specifies that the origin is a primary origin. A value of 30 specifies that the origin is a secondary origin.
 * @property type The type of the origin server. Valid values: `ipaddr`, `domain`, `oss`.
 * @property weight The weight of the origin server. You must specify a value that is less than `100`. Default value: `10`.
 */
public data class IpaDomainSourceArgs(
    public val content: Output<String>,
    public val port: Output<Int>,
    public val priority: Output<String>,
    public val type: Output<String>,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.IpaDomainSourceArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.IpaDomainSourceArgs =
        com.pulumi.alicloud.dcdn.inputs.IpaDomainSourceArgs.builder()
            .content(content.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpaDomainSourceArgs].
 */
@PulumiTagMarker
public class IpaDomainSourceArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var port: Output<Int>? = null

    private var priority: Output<String>? = null

    private var type: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The address of the origin server. You can specify an IP address or a domain name.
     */
    @JvmName("rowjpfwmqdfqtpou")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The custom port number. Valid values: `0` to `65535`.
     */
    @JvmName("niwcoyncyjxstwpb")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The priority of the origin server. Valid values: `20` and `30`. Default value: `20`. A value of 20 specifies that the origin is a primary origin. A value of 30 specifies that the origin is a secondary origin.
     */
    @JvmName("vhvxwyxlvcyocrku")
    public suspend fun priority(`value`: Output<String>) {
        this.priority = value
    }

    /**
     * @param value The type of the origin server. Valid values: `ipaddr`, `domain`, `oss`.
     */
    @JvmName("ndydsuqbdcygrhep")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The weight of the origin server. You must specify a value that is less than `100`. Default value: `10`.
     */
    @JvmName("odrjrbpqxgkownoj")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The address of the origin server. You can specify an IP address or a domain name.
     */
    @JvmName("yblddiaholdtkcmv")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The custom port number. Valid values: `0` to `65535`.
     */
    @JvmName("fqbrrvwetlidwmqc")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The priority of the origin server. Valid values: `20` and `30`. Default value: `20`. A value of 20 specifies that the origin is a primary origin. A value of 30 specifies that the origin is a secondary origin.
     */
    @JvmName("dorgqatgeepxabmw")
    public suspend fun priority(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The type of the origin server. Valid values: `ipaddr`, `domain`, `oss`.
     */
    @JvmName("mvlrwjrjejfgwgih")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The weight of the origin server. You must specify a value that is less than `100`. Default value: `10`.
     */
    @JvmName("ourkicftxpdmvmua")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): IpaDomainSourceArgs = IpaDomainSourceArgs(
        content = content ?: throw PulumiNullFieldException("content"),
        port = port ?: throw PulumiNullFieldException("port"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        type = type ?: throw PulumiNullFieldException("type"),
        weight = weight ?: throw PulumiNullFieldException("weight"),
    )
}
