@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.WafRuleConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The match field.
 * @property opValue The logical symbol.
 * @property subKey The match subfield.
 * @property values The match content. Separate multiple values with commas (,).
 */
public data class WafRuleConditionArgs(
    public val key: Output<String>,
    public val opValue: Output<String>,
    public val subKey: Output<String>? = null,
    public val values: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.WafRuleConditionArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.WafRuleConditionArgs =
        com.pulumi.alicloud.dcdn.inputs.WafRuleConditionArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .opValue(opValue.applyValue({ args0 -> args0 }))
            .subKey(subKey?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WafRuleConditionArgs].
 */
@PulumiTagMarker
public class WafRuleConditionArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var opValue: Output<String>? = null

    private var subKey: Output<String>? = null

    private var values: Output<String>? = null

    /**
     * @param value The match field.
     */
    @JvmName("xdlohqvugoktwtfk")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The logical symbol.
     */
    @JvmName("tmealrwbeooyrhim")
    public suspend fun opValue(`value`: Output<String>) {
        this.opValue = value
    }

    /**
     * @param value The match subfield.
     */
    @JvmName("jccoaybwqrrkidne")
    public suspend fun subKey(`value`: Output<String>) {
        this.subKey = value
    }

    /**
     * @param value The match content. Separate multiple values with commas (,).
     */
    @JvmName("qfxbacpkvqijolfh")
    public suspend fun values(`value`: Output<String>) {
        this.values = value
    }

    /**
     * @param value The match field.
     */
    @JvmName("ouvlflfvprpjqeng")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The logical symbol.
     */
    @JvmName("eoqkafqrbyngyswn")
    public suspend fun opValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.opValue = mapped
    }

    /**
     * @param value The match subfield.
     */
    @JvmName("wbxruieyetijnudc")
    public suspend fun subKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subKey = mapped
    }

    /**
     * @param value The match content. Separate multiple values with commas (,).
     */
    @JvmName("lnspjmjfvyiqxoio")
    public suspend fun values(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): WafRuleConditionArgs = WafRuleConditionArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        opValue = opValue ?: throw PulumiNullFieldException("opValue"),
        subKey = subKey,
        values = values,
    )
}
