@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property interval Statistical duration, 5-1800.
 * @property status Response code statistics. See `status` below.
 * @property subKey The subfield of the target field. If you set `target` to `Header`, `Query String Parameter`, or `Cookie Name`, you must configure `sub_key`.
 * @property target The statistical field for frequency control. Currently, `IP`, `Header`, `Query String Parameter`, `Cookie Name`, `Session` is supported.
 * @property threshold The trigger threshold of rate limiting. Valid values: 2 to 500000. Unit: requests.
 * @property ttl The validity period of the blacklist. Valid values: 60 to 86400. Unit: seconds.
 */
public data class WafRuleRateLimitArgs(
    public val interval: Output<Int>? = null,
    public val status: Output<WafRuleRateLimitStatusArgs>? = null,
    public val subKey: Output<String>? = null,
    public val target: Output<String>? = null,
    public val threshold: Output<Int>? = null,
    public val ttl: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitArgs =
        com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitArgs.builder()
            .interval(interval?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subKey(subKey?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .threshold(threshold?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WafRuleRateLimitArgs].
 */
@PulumiTagMarker
public class WafRuleRateLimitArgsBuilder internal constructor() {
    private var interval: Output<Int>? = null

    private var status: Output<WafRuleRateLimitStatusArgs>? = null

    private var subKey: Output<String>? = null

    private var target: Output<String>? = null

    private var threshold: Output<Int>? = null

    private var ttl: Output<Int>? = null

    /**
     * @param value Statistical duration, 5-1800.
     */
    @JvmName("hjcltuvhuopuksxa")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Response code statistics. See `status` below.
     */
    @JvmName("kjgfvxscmwogfcov")
    public suspend fun status(`value`: Output<WafRuleRateLimitStatusArgs>) {
        this.status = value
    }

    /**
     * @param value The subfield of the target field. If you set `target` to `Header`, `Query String Parameter`, or `Cookie Name`, you must configure `sub_key`.
     */
    @JvmName("aiqrimnudxbeupuc")
    public suspend fun subKey(`value`: Output<String>) {
        this.subKey = value
    }

    /**
     * @param value The statistical field for frequency control. Currently, `IP`, `Header`, `Query String Parameter`, `Cookie Name`, `Session` is supported.
     */
    @JvmName("fmgdfcaakcaskpca")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The trigger threshold of rate limiting. Valid values: 2 to 500000. Unit: requests.
     */
    @JvmName("bovmastdteuomhom")
    public suspend fun threshold(`value`: Output<Int>) {
        this.threshold = value
    }

    /**
     * @param value The validity period of the blacklist. Valid values: 60 to 86400. Unit: seconds.
     */
    @JvmName("xkhycmovaojhmiwq")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value Statistical duration, 5-1800.
     */
    @JvmName("sgleooyvrmmwybwu")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Response code statistics. See `status` below.
     */
    @JvmName("hvjwkndixthprdeo")
    public suspend fun status(`value`: WafRuleRateLimitStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param argument Response code statistics. See `status` below.
     */
    @JvmName("bpncxtjnwtdqxxsb")
    public suspend fun status(argument: suspend WafRuleRateLimitStatusArgsBuilder.() -> Unit) {
        val toBeMapped = WafRuleRateLimitStatusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.status = mapped
    }

    /**
     * @param value The subfield of the target field. If you set `target` to `Header`, `Query String Parameter`, or `Cookie Name`, you must configure `sub_key`.
     */
    @JvmName("fhlmvuaovwssejto")
    public suspend fun subKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subKey = mapped
    }

    /**
     * @param value The statistical field for frequency control. Currently, `IP`, `Header`, `Query String Parameter`, `Cookie Name`, `Session` is supported.
     */
    @JvmName("imyrgcccjwiwwhed")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value The trigger threshold of rate limiting. Valid values: 2 to 500000. Unit: requests.
     */
    @JvmName("ttpofeurbxhbgknj")
    public suspend fun threshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value The validity period of the blacklist. Valid values: 60 to 86400. Unit: seconds.
     */
    @JvmName("ufykerpxihxtpvwf")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): WafRuleRateLimitArgs = WafRuleRateLimitArgs(
        interval = interval,
        status = status,
        subKey = subKey,
        target = target,
        threshold = threshold,
        ttl = ttl,
    )
}
