@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.inputs

import com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property code The HTTP status code returned.
 * @property count The number of times that the HTTP status code that was returned. Valid values: 2 to 50000. You can configure only one of the `ratio` and `count` fields.
 * @property ratio The percentage of HTTP status codes. Valid values: 1 to 100. You can configure only one of the `ratio` and `count` fields.
 */
public data class WafRuleRateLimitStatusArgs(
    public val code: Output<String>? = null,
    public val count: Output<Int>? = null,
    public val ratio: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitStatusArgs> {
    override fun toJava(): com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitStatusArgs =
        com.pulumi.alicloud.dcdn.inputs.WafRuleRateLimitStatusArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .count(count?.applyValue({ args0 -> args0 }))
            .ratio(ratio?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WafRuleRateLimitStatusArgs].
 */
@PulumiTagMarker
public class WafRuleRateLimitStatusArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var count: Output<Int>? = null

    private var ratio: Output<Int>? = null

    /**
     * @param value The HTTP status code returned.
     */
    @JvmName("qmanhipyndppfbpd")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value The number of times that the HTTP status code that was returned. Valid values: 2 to 50000. You can configure only one of the `ratio` and `count` fields.
     */
    @JvmName("hguwywcnlutcxxei")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The percentage of HTTP status codes. Valid values: 1 to 100. You can configure only one of the `ratio` and `count` fields.
     */
    @JvmName("dcasltbdmhqolxef")
    public suspend fun ratio(`value`: Output<Int>) {
        this.ratio = value
    }

    /**
     * @param value The HTTP status code returned.
     */
    @JvmName("nqpbtjpmpbphkjyt")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value The number of times that the HTTP status code that was returned. Valid values: 2 to 50000. You can configure only one of the `ratio` and `count` fields.
     */
    @JvmName("eugygiwbkqcliadj")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The percentage of HTTP status codes. Valid values: 1 to 100. You can configure only one of the `ratio` and `count` fields.
     */
    @JvmName("jnwwdiytspmghrdc")
    public suspend fun ratio(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ratio = mapped
    }

    internal fun build(): WafRuleRateLimitStatusArgs = WafRuleRateLimitStatusArgs(
        code = code,
        count = count,
        ratio = ratio,
    )
}
