@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The address of the source station.
 * @property port The port number. Valid values: `443` and `80`. Default to `80`.
 * @property priority The priority of the origin if multiple origins are specified. Default to `20`.
 * @property type The type of the origin. Valid values:
 * @property weight The weight of the origin if multiple origins are specified. Default to `10`.
 */
public data class DomainSource(
    public val content: String? = null,
    public val port: Int? = null,
    public val priority: String? = null,
    public val type: String? = null,
    public val weight: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.DomainSource): DomainSource =
            DomainSource(
                content = javaType.content().map({ args0 -> args0 }).orElse(null),
                port = javaType.port().map({ args0 -> args0 }).orElse(null),
                priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
                weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
            )
    }
}
