@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedHosts Allowed DCDN domain names.
 * @property codeRev The version number of the code.
 * @property specName The specification of the CPU time slice. Valid values: `5ms`, `50ms`, `100ms`.
 */
public data class ErEnvConfPresetCanaryZhejiang(
    public val allowedHosts: List<String>? = null,
    public val codeRev: String? = null,
    public val specName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.ErEnvConfPresetCanaryZhejiang): ErEnvConfPresetCanaryZhejiang = ErEnvConfPresetCanaryZhejiang(
            allowedHosts = javaType.allowedHosts().map({ args0 -> args0 }),
            codeRev = javaType.codeRev().map({ args0 -> args0 }).orElse(null),
            specName = javaType.specName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
