@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certName Indicates the name of the certificate.
 * @property cname The canonical name (CNAME) of the accelerated domain.
 * @property description The reason that causes the review failure.
 * @property domainName The name of the DCDN Domain.
 * @property gmtModified The time when the accelerated domain was last modified.
 * @property id The ID of the DCDN Domain.
 * @property resourceGroupId The ID of the resource group.
 * @property scope The acceleration region.
 * @property sources The origin information.
 * @property sslProtocol Indicates whether the SSL certificate is enabled.
 * @property sslPub Indicates the public key of the certificate.
 * @property status The status of DCDN Domain.
 */
public data class GetDomainsDomain(
    public val certName: String,
    public val cname: String,
    public val description: String,
    public val domainName: String,
    public val gmtModified: String,
    public val id: String,
    public val resourceGroupId: String,
    public val scope: String,
    public val sources: List<GetDomainsDomainSource>,
    public val sslProtocol: String,
    public val sslPub: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetDomainsDomain): GetDomainsDomain = GetDomainsDomain(
            certName = javaType.certName(),
            cname = javaType.cname(),
            description = javaType.description(),
            domainName = javaType.domainName(),
            gmtModified = javaType.gmtModified(),
            id = javaType.id(),
            resourceGroupId = javaType.resourceGroupId(),
            scope = javaType.scope(),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetDomainsDomainSource.Companion.toKotlin(args0)
                })
            }),
            sslProtocol = javaType.sslProtocol(),
            sslPub = javaType.sslPub(),
            status = javaType.status(),
        )
    }
}
