@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The origin address.
 * @property enabled The status of the origin.
 * @property port The port number.
 * @property priority The priority of the origin if multiple origins are specified.
 * @property type The type of the origin. Valid values:
 * @property weight The weight of the origin if multiple origins are specified.
 */
public data class GetDomainsDomainSource(
    public val content: String,
    public val enabled: String,
    public val port: Int,
    public val priority: String,
    public val type: String,
    public val weight: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetDomainsDomainSource): GetDomainsDomainSource = GetDomainsDomainSource(
            content = javaType.content(),
            enabled = javaType.enabled(),
            port = javaType.port(),
            priority = javaType.priority(),
            type = javaType.type(),
            weight = javaType.weight(),
        )
    }
}
